/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.properties.PropertyUtils;

public class MaterialConfigurationProvider {
    private static MaterialConfigurationProvider instance;
    private final boolean isRelaxCodeConstraints;

    public static final MaterialConfigurationProvider getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Instance not yet initialized");
        }
        return instance;
    }

    public static final MaterialConfigurationProvider initializeForTesting(boolean isRelaxCodeConstraints) {
        MaterialConfigurationProvider oldInstance = instance;
        instance = new MaterialConfigurationProvider(isRelaxCodeConstraints);
        return oldInstance;
    }

    public static void restoreFromTesting(MaterialConfigurationProvider provider) {
        instance = provider;
    }

    static final void initialize(String relaxCodeConstraints) {
        boolean isRelaxCodeConstraints = MaterialConfigurationProvider.parseBooleanValue(relaxCodeConstraints, false);
        instance = new MaterialConfigurationProvider(isRelaxCodeConstraints);
    }

    private MaterialConfigurationProvider(boolean isRelaxCodeConstraints) {
        this.isRelaxCodeConstraints = isRelaxCodeConstraints;
    }

    public boolean isRelaxedCodeConstraints() {
        return this.isRelaxCodeConstraints;
    }

    public boolean isStrictCodeConstraints() {
        return !this.isRelaxedCodeConstraints();
    }

    private static boolean parseBooleanValue(String stringValue, boolean defaultValue) {
        PropertyUtils.Boolean value = PropertyUtils.Boolean.getBoolean(stringValue);
        if (value == null) {
            return defaultValue;
        }
        return value == PropertyUtils.Boolean.TRUE;
    }
}

