/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.cpdsadapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.cpdsadapter.ConnectionImpl;
import org.apache.commons.dbcp.cpdsadapter.PoolablePreparedStatementStub;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class PooledConnectionImpl
implements PooledConnection,
KeyedPoolableObjectFactory {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection = null;
    private final DelegatingConnection delegatingConnection;
    private Connection logicalConnection = null;
    private final Vector eventListeners;
    private final Vector statementEventListeners = new Vector();
    boolean isClosed;
    protected KeyedObjectPool pstmtPool = null;
    private boolean accessToUnderlyingConnectionAllowed = false;

    PooledConnectionImpl(Connection connection, KeyedObjectPool keyedObjectPool) {
        this.connection = connection;
        this.delegatingConnection = connection instanceof DelegatingConnection ? (DelegatingConnection)connection : new DelegatingConnection(connection);
        this.eventListeners = new Vector();
        this.isClosed = false;
        if (keyedObjectPool != null) {
            this.pstmtPool = keyedObjectPool;
            this.pstmtPool.setFactory((KeyedPoolableObjectFactory)this);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.eventListeners.contains(connectionEventListener)) {
            this.eventListeners.add(connectionEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        block14: {
            this.assertOpen();
            this.isClosed = true;
            try {
                if (this.pstmtPool == null) break block14;
                try {
                    this.pstmtPool.close();
                }
                finally {
                    this.pstmtPool = null;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLNestedException("Cannot close connection (return to pool failed)", exception);
            }
            finally {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, withoutits previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection, this.isAccessToUnderlyingConnectionAllowed());
        return this.logicalConnection;
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.eventListeners.remove(connectionEventListener);
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, withoutits last Connection being closed.");
        }
    }

    void notifyListeners() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        Object[] objectArray = this.eventListeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ConnectionEventListener)objectArray[i]).connectionClosed(connectionEvent);
        }
    }

    PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, n, n2);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, n);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string, n));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, n, n2, n3);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string, n, n2, n3));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, nArray);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string, nArray));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, stringArray);
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject(this.createKey(string, stringArray));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    protected Object createKey(String string, int n) {
        return new PStmtKey(this.normalizeSQL(string), n);
    }

    protected Object createKey(String string, int n, int n2, int n3) {
        return new PStmtKey(this.normalizeSQL(string), n, n2, n3);
    }

    protected Object createKey(String string, int[] nArray) {
        return new PStmtKey(this.normalizeSQL(string), nArray);
    }

    protected Object createKey(String string, String[] stringArray) {
        return new PStmtKey(this.normalizeSQL(string), stringArray);
    }

    protected Object createKey(String string, int n, int n2) {
        return new PStmtKey(this.normalizeSQL(string), n, n2);
    }

    protected Object createKey(String string) {
        return new PStmtKey(this.normalizeSQL(string));
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    public Object makeObject(Object object) throws Exception {
        if (null == object || !(object instanceof PStmtKey)) {
            throw new IllegalArgumentException();
        }
        PStmtKey pStmtKey = (PStmtKey)object;
        if (null == pStmtKey._resultSetType && null == pStmtKey._resultSetConcurrency) {
            if (null == pStmtKey._autoGeneratedKeys) {
                return new PoolablePreparedStatementStub(this.connection.prepareStatement(pStmtKey._sql), pStmtKey, this.pstmtPool, this.delegatingConnection);
            }
            return new PoolablePreparedStatementStub(this.connection.prepareStatement(pStmtKey._sql, pStmtKey._autoGeneratedKeys), pStmtKey, this.pstmtPool, this.delegatingConnection);
        }
        return new PoolablePreparedStatementStub(this.connection.prepareStatement(pStmtKey._sql, pStmtKey._resultSetType, pStmtKey._resultSetConcurrency), pStmtKey, this.pstmtPool, this.delegatingConnection);
    }

    public void destroyObject(Object object, Object object2) throws Exception {
        if (object2 instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)object2).getInnermostDelegate().close();
        } else {
            ((PreparedStatement)object2).close();
        }
    }

    public boolean validateObject(Object object, Object object2) {
        return true;
    }

    public void activateObject(Object object, Object object2) throws Exception {
        ((PoolablePreparedStatementStub)object2).activate();
    }

    public void passivateObject(Object object, Object object2) throws Exception {
        ((PreparedStatement)object2).clearParameters();
        ((PoolablePreparedStatementStub)object2).passivate();
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    static class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;
        protected Integer _autoGeneratedKeys = null;
        protected Integer _resultSetHoldability = null;
        protected int[] _columnIndexes = null;
        protected String[] _columnNames = null;

        PStmtKey(String string) {
            this._sql = string;
        }

        PStmtKey(String string, int n, int n2) {
            this._sql = string;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
        }

        PStmtKey(String string, int n) {
            this._sql = string;
            this._autoGeneratedKeys = new Integer(n);
        }

        PStmtKey(String string, int n, int n2, int n3) {
            this._sql = string;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
            this._resultSetHoldability = new Integer(n3);
        }

        PStmtKey(String string, int[] nArray) {
            this._sql = string;
            this._columnIndexes = nArray;
        }

        PStmtKey(String string, String[] stringArray) {
            this._sql = string;
            this._columnNames = stringArray;
        }

        public boolean equals(Object object) {
            try {
                PStmtKey pStmtKey = (PStmtKey)object;
                return (null == this._sql && null == pStmtKey._sql || this._sql.equals(pStmtKey._sql)) && (null == this._resultSetType && null == pStmtKey._resultSetType || this._resultSetType.equals(pStmtKey._resultSetType)) && (null == this._resultSetConcurrency && null == pStmtKey._resultSetConcurrency || this._resultSetConcurrency.equals(pStmtKey._resultSetConcurrency)) && (null == this._autoGeneratedKeys && null == pStmtKey._autoGeneratedKeys || this._autoGeneratedKeys.equals(pStmtKey._autoGeneratedKeys)) && (null == this._resultSetHoldability && null == pStmtKey._resultSetHoldability || this._resultSetHoldability.equals(pStmtKey._resultSetHoldability)) && (null == this._columnIndexes && null == pStmtKey._columnIndexes || Arrays.equals(this._columnIndexes, pStmtKey._columnIndexes)) && (null == this._columnNames && null == pStmtKey._columnNames || Arrays.equals(this._columnNames, pStmtKey._columnNames));
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public int hashCode() {
            return null == this._sql ? 0 : this._sql.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PStmtKey: sql=");
            stringBuffer.append(this._sql);
            stringBuffer.append(", resultSetType=");
            stringBuffer.append(this._resultSetType);
            stringBuffer.append(", resultSetConcurrency=");
            stringBuffer.append(this._resultSetConcurrency);
            stringBuffer.append(", autoGeneratedKeys=");
            stringBuffer.append(this._autoGeneratedKeys);
            stringBuffer.append(", resultSetHoldability=");
            stringBuffer.append(this._resultSetHoldability);
            stringBuffer.append(", columnIndexes=");
            this.arrayToString(stringBuffer, this._columnIndexes);
            stringBuffer.append(", columnNames=");
            this.arrayToString(stringBuffer, this._columnNames);
            return stringBuffer.toString();
        }

        private void arrayToString(StringBuffer stringBuffer, int[] nArray) {
            if (nArray == null) {
                stringBuffer.append("null");
                return;
            }
            stringBuffer.append('[');
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(nArray[i]);
            }
            stringBuffer.append(']');
        }

        private void arrayToString(StringBuffer stringBuffer, String[] stringArray) {
            if (stringArray == null) {
                stringBuffer.append("null");
                return;
            }
            stringBuffer.append('[');
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(']');
        }
    }
}

