/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.PooledConnectionManager;
import org.apache.commons.dbcp.datasources.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final boolean _rollbackAfterValidation;
    private final KeyedObjectPool _pool;
    private final Map validatingMap = new HashMap();
    private final WeakHashMap pcMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, KeyedObjectPool keyedObjectPool, String string) {
        this(connectionPoolDataSource, keyedObjectPool, string, false);
    }

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, KeyedObjectPool keyedObjectPool, String string, boolean bl) {
        this._cpds = connectionPoolDataSource;
        this._pool = keyedObjectPool;
        keyedObjectPool.setFactory((KeyedPoolableObjectFactory)this);
        this._validationQuery = string;
        this._rollbackAfterValidation = bl;
    }

    public KeyedObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject(Object object) throws Exception {
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        UserPassKey userPassKey = (UserPassKey)object;
        PooledConnection pooledConnection = null;
        String string = userPassKey.getUsername();
        String string2 = userPassKey.getPassword();
        pooledConnection = string == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(string, string2);
        if (pooledConnection == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pooledConnection.addConnectionEventListener(this);
        pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, string, string2);
        this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        return pooledConnectionAndInfo;
    }

    public void destroyObject(Object object, Object object2) throws Exception {
        if (object2 instanceof PooledConnectionAndInfo) {
            PooledConnection pooledConnection = ((PooledConnectionAndInfo)object2).getPooledConnection();
            pooledConnection.removeConnectionEventListener(this);
            this.pcMap.remove(pooledConnection);
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateObject(Object object, Object object2) {
        boolean bl = false;
        if (!(object2 instanceof PooledConnectionAndInfo)) return false;
        PooledConnection pooledConnection = ((PooledConnectionAndInfo)object2).getPooledConnection();
        String string = this._validationQuery;
        if (null == string) return true;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        this.validatingMap.put(pooledConnection, null);
        try {
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            bl = resultSet.next();
            if (!this._rollbackAfterValidation) return bl;
            connection.rollback();
            return bl;
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
            this.validatingMap.remove(pooledConnection);
        }
    }

    public void passivateObject(Object object, Object object2) {
    }

    public void activateObject(Object object, Object object2) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingMap.containsKey(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject((Object)pooledConnectionAndInfo.getUserPassKey(), (Object)pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this._pool.invalidateObject((Object)pooledConnectionAndInfo.getUserPassKey(), (Object)pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject((Object)pooledConnectionAndInfo.getUserPassKey(), (Object)pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }

    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey userPassKey = pooledConnectionAndInfo.getUserPassKey();
        try {
            this._pool.invalidateObject((Object)userPassKey, (Object)pooledConnectionAndInfo);
            this._pool.clear((Object)userPassKey);
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(exception);
        }
    }

    public void setPassword(String string) {
    }

    public void closePool(String string) throws SQLException {
        try {
            this._pool.clear((Object)new UserPassKey(string, null));
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(exception);
        }
    }
}

