/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnMatcher;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public class CursorBuilder {
    private final Table _table;
    private Index _index;
    private Object[] _startRow;
    private boolean _startRowInclusive = true;
    private Object[] _endRow;
    private boolean _endRowInclusive = true;
    private boolean _beforeFirst = true;
    private Cursor.Savepoint _savepoint;
    private ColumnMatcher _columnMatcher;

    public CursorBuilder(Table table) {
        this._table = table;
    }

    public CursorBuilder beforeFirst() {
        this._beforeFirst = true;
        return this;
    }

    public CursorBuilder afterLast() {
        this._beforeFirst = false;
        return this;
    }

    public CursorBuilder restoreSavepoint(Cursor.Savepoint savepoint) {
        this._savepoint = savepoint;
        return this;
    }

    public CursorBuilder setIndex(Index index) {
        this._index = index;
        return this;
    }

    public CursorBuilder setIndexByName(String indexName) {
        return this.setIndex(this._table.getIndex(indexName));
    }

    public CursorBuilder setIndexByColumns(Column ... columns) {
        List<Column> searchColumns = Arrays.asList(columns);
        boolean found = false;
        for (Index index : this._table.getIndexes()) {
            List<Index.ColumnDescriptor> indexColumns = index.getColumns();
            if (indexColumns.size() != searchColumns.size()) continue;
            Iterator<Column> sIter = searchColumns.iterator();
            Iterator iIter = indexColumns.iterator();
            boolean matches = true;
            while (sIter.hasNext()) {
                Column sCol = sIter.next();
                Index.ColumnDescriptor iCol = (Index.ColumnDescriptor)iIter.next();
                if (ObjectUtils.equals((Object)sCol.getName(), (Object)iCol.getName())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            this._index = index;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Index with columns " + searchColumns + " does not exist in table " + this._table);
        }
        return this;
    }

    public CursorBuilder setSpecificRow(Object[] specificRow) {
        this.setStartRow(specificRow);
        this.setEndRow(specificRow);
        return this;
    }

    public CursorBuilder setSpecificEntry(Object ... specificEntry) {
        if (specificEntry != null) {
            this.setSpecificRow(this._index.constructIndexRowFromEntry(specificEntry));
        }
        return this;
    }

    public CursorBuilder setStartRow(Object[] startRow) {
        this._startRow = startRow;
        return this;
    }

    public CursorBuilder setStartEntry(Object ... startEntry) {
        if (startEntry != null) {
            this.setStartRow(this._index.constructIndexRowFromEntry(startEntry));
        }
        return this;
    }

    public CursorBuilder setStartRowInclusive(boolean inclusive) {
        this._startRowInclusive = inclusive;
        return this;
    }

    public CursorBuilder setEndRow(Object[] endRow) {
        this._endRow = endRow;
        return this;
    }

    public CursorBuilder setEndEntry(Object ... endEntry) {
        if (endEntry != null) {
            this.setEndRow(this._index.constructIndexRowFromEntry(endEntry));
        }
        return this;
    }

    public CursorBuilder setEndRowInclusive(boolean inclusive) {
        this._endRowInclusive = inclusive;
        return this;
    }

    public CursorBuilder setColumnMatcher(ColumnMatcher columnMatcher) {
        this._columnMatcher = columnMatcher;
        return this;
    }

    public Cursor toCursor() throws IOException {
        Cursor cursor = null;
        cursor = this._index == null ? Cursor.createCursor(this._table) : Cursor.createIndexCursor(this._table, this._index, this._startRow, this._startRowInclusive, this._endRow, this._endRowInclusive);
        cursor.setColumnMatcher(this._columnMatcher);
        if (this._savepoint == null) {
            if (!this._beforeFirst) {
                cursor.afterLast();
            }
        } else {
            cursor.restoreSavepoint(this._savepoint);
        }
        return cursor;
    }
}

