/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.nosandbox;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngReader;
import ar.com.hjg.pngj.PngWriter;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.PngjOutputException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileHelper {
    public static InputStream openFileForReading(File file) {
        BufferedInputStream isx = null;
        if (file == null || !file.exists() || !file.canRead()) {
            throw new PngjInputException("Can open file for reading (" + file + ")");
        }
        try {
            isx = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new PngjInputException("Error opening file for reading (" + file + ") : " + e.getMessage());
        }
        return isx;
    }

    public static OutputStream openFileForWriting(File file, boolean allowOverwrite) {
        FileOutputStream osx = null;
        if (file.exists() && !allowOverwrite) {
            throw new PngjOutputException("File already exists (" + file + ") and overwrite=false");
        }
        try {
            osx = new FileOutputStream(file);
        }
        catch (Exception e) {
            throw new PngjOutputException("error opening " + file + " for writing", e);
        }
        return osx;
    }

    public static PngWriter createPngWriter(File file, ImageInfo imgInfo, boolean allowOverwrite) {
        return new PngWriter(FileHelper.openFileForWriting(file, allowOverwrite), imgInfo, file.getName());
    }

    public static PngReader createPngReader(File file) {
        return new PngReader(FileHelper.openFileForReading(file), file.getName());
    }
}

