/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.etlserver.proteomics.AbstractDataSetInfoExtractorWithService;
import ch.systemsx.cisd.openbis.etlserver.proteomics.Util;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataSetInfoExtractorForMSInjection
extends AbstractDataSetInfoExtractorWithService {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetInfoExtractorForMSInjection.class);
    static final String MS_INJECTION_PROPERTIES_FILE = "ms-injection.properties";
    static final String DATA_SET_PROPERTIES_FILE = "data-set.properties";
    static final String PROJECT_CODE_KEY = "PROJECT_CODE";
    static final String EXPERIMENT_CODE_KEY = "EXPERIMENT_CODE";
    static final String SAMPLE_CODE_KEY = "SAMPLE_CODE";
    static final String BIOLOGICAL_SAMPLE_IDENTIFIER_KEY = "BIOLOGICAL_SAMPLE_IDENTIFIER";
    static final String USER_KEY = "USER";
    static final String DATA_SET_TYPE_KEY = "DATA_SET_TYPE";
    static final String FILE_TYPE_KEY = "FILE_TYPE";
    static final String PARENT_TYPE_KEY = "PARENT_TYPE";
    static final String EXPERIMENT_TYPE_CODE = "MS_INJECT";

    public DataSetInfoExtractorForMSInjection(Properties properties) {
        this(ServiceProvider.getOpenBISService());
    }

    DataSetInfoExtractorForMSInjection(IEncapsulatedOpenBISService service) {
        super(service);
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        Properties sampleProperties = Util.loadPropertiesFile(incomingDataSetPath, MS_INJECTION_PROPERTIES_FILE);
        DataSetInformation info = new DataSetInformation();
        info.setSpaceCode("MS_DATA");
        info.setSampleCode(PropertyUtils.getMandatoryProperty(sampleProperties, SAMPLE_CODE_KEY));
        SampleIdentifier sampleIdentifier = info.getSampleIdentifier();
        ExperimentIdentifier experimentIdentifier = this.getExperimentIdentifier(sampleProperties);
        this.getOrCreateExperiment(experimentIdentifier);
        info.setExperimentIdentifier(experimentIdentifier);
        long sampleID = this.registerOrUpdateSample(sampleIdentifier, experimentIdentifier, sampleProperties);
        Properties dataSetProperties = Util.loadPropertiesFile(incomingDataSetPath, DATA_SET_PROPERTIES_FILE);
        String dataSetTypeCode = PropertyUtils.getMandatoryProperty(dataSetProperties, DATA_SET_TYPE_KEY);
        String parentTypeOrNull = dataSetProperties.getProperty(PARENT_TYPE_KEY);
        dataSetProperties.remove(DATA_SET_TYPE_KEY);
        dataSetProperties.remove(FILE_TYPE_KEY);
        dataSetProperties.remove(PARENT_TYPE_KEY);
        this.setDataSetPropertiesFor(info, dataSetProperties, dataSetTypeCode);
        if (parentTypeOrNull != null) {
            List<AbstractExternalData> dataSets = this.service.listDataSetsBySampleID(sampleID, false);
            CodeWithRegistration youngestDataSet = null;
            for (AbstractExternalData dataSet : dataSets) {
                if (!dataSet.getDataSetType().getCode().equals(parentTypeOrNull) || youngestDataSet != null && this.timeStamp((AbstractExternalData)youngestDataSet) >= this.timeStamp(dataSet)) continue;
                youngestDataSet = dataSet;
            }
            if (youngestDataSet != null) {
                info.setParentDataSetCodes(Arrays.asList(youngestDataSet.getCode()));
            }
        }
        return info;
    }

    private long registerOrUpdateSample(SampleIdentifier sampleIdentifier, ExperimentIdentifier experimentIdentifier, Properties properties) {
        String[] stringArray;
        SampleType sampleType = this.service.getSampleType("MS_INJECTION");
        Sample sample = this.service.tryGetSampleWithExperiment(sampleIdentifier);
        String biologicalSampleIdentifier = this.tryToGetBiologicalSampleIdentifier(properties);
        if (sample == null) {
            NewSample newSample = new NewSample();
            newSample.setSampleType(sampleType);
            newSample.setExperimentIdentifier(experimentIdentifier.toString());
            newSample.setIdentifier(sampleIdentifier.toString());
            if (biologicalSampleIdentifier != null) {
                newSample.setParents(biologicalSampleIdentifier);
            }
            IEntityProperty[] sampleProperties = Util.getAndCheckProperties(properties, sampleType);
            newSample.setProperties(sampleProperties);
            return this.service.registerSample(newSample, properties.getProperty(USER_KEY));
        }
        TechId sampleID = new TechId(sample.getId());
        List<IEntityProperty> propertiesList = Util.getProperties(properties, sampleType, new ArrayList<String>());
        Set<NewAttachment> emptySet = Collections.emptySet();
        int version = sample.getVersion();
        if (biologicalSampleIdentifier == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = biologicalSampleIdentifier;
        }
        this.service.updateSample(new SampleUpdatesDTO(sampleID, propertiesList, experimentIdentifier, emptySet, version, sampleIdentifier, null, stringArray));
        return sample.getId();
    }

    private String tryToGetBiologicalSampleIdentifier(Properties properties) {
        Sample bioSample;
        String biologicalSampleIdentifier = properties.getProperty(BIOLOGICAL_SAMPLE_IDENTIFIER_KEY);
        if (biologicalSampleIdentifier != null && (bioSample = this.service.tryGetSampleWithExperiment(SampleIdentifierFactory.parse(biologicalSampleIdentifier))) == null) {
            biologicalSampleIdentifier = null;
            operationLog.warn((Object)("Property BIOLOGICAL_SAMPLE_IDENTIFIER will be ignored because the specified biological sample " + biologicalSampleIdentifier + " does not exist."));
        }
        return biologicalSampleIdentifier;
    }

    private long timeStamp(AbstractExternalData dataSet) {
        return dataSet.getRegistrationDate().getTime();
    }

    private void setDataSetPropertiesFor(DataSetInformation info, Properties dataSetProperties, String dataSetTypeCode) {
        DataSetType dataSetType = this.service.getDataSetType(dataSetTypeCode).getDataSetType();
        IEntityProperty[] props = Util.getAndCheckProperties(dataSetProperties, dataSetType);
        ArrayList<NewProperty> properties = new ArrayList<NewProperty>();
        IEntityProperty[] iEntityPropertyArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            IEntityProperty p = iEntityPropertyArray[n2];
            properties.add(new NewProperty(p.getPropertyType().getCode(), p.tryGetAsString()));
            ++n2;
        }
        info.setDataSetProperties(properties);
    }

    private long getOrCreateExperiment(ExperimentIdentifier identifier) {
        Experiment experiment = this.service.tryGetExperiment(identifier);
        if (experiment == null) {
            return this.service.registerExperiment(new NewExperiment(identifier.toString(), EXPERIMENT_TYPE_CODE));
        }
        return experiment.getId();
    }

    private ExperimentIdentifier getExperimentIdentifier(Properties msInjectionProperties) {
        String projectCode = PropertyUtils.getMandatoryProperty(msInjectionProperties, PROJECT_CODE_KEY);
        String experimentCode = PropertyUtils.getMandatoryProperty(msInjectionProperties, EXPERIMENT_CODE_KEY);
        return new ExperimentIdentifier(null, "MS_DATA", projectCode, experimentCode);
    }
}

