/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.DateRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityWithDeletionInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class RevertDeletionConfirmationDialog
extends AbstractDataConfirmationDialog<List<Deletion>> {
    private static final int LABEL_WIDTH = 60;
    private static final int FIELD_WIDTH = 180;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final AsyncCallback<Void> callback;
    private final IEntityWithDeletionInformation deletedEntityOrNull;

    public RevertDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<Deletion> deletions, AsyncCallback<Void> callback) {
        super(viewContext, deletions, viewContext.getMessage("revert_deletions_confirmation_title", new Object[0]));
        this.viewContext = viewContext;
        this.callback = callback;
        this.deletedEntityOrNull = null;
    }

    public RevertDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, Deletion deletion, AsyncCallback<Void> callback) {
        this(viewContext, Collections.singletonList(deletion), callback);
    }

    public RevertDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, IEntityWithDeletionInformation deletedEntity, AsyncCallback<Void> callback) {
        super(viewContext, Collections.singletonList(deletedEntity.getDeletion()), viewContext.getMessage("revert_deletions_confirmation_title", new Object[0]));
        this.viewContext = viewContext;
        this.callback = callback;
        this.deletedEntityOrNull = deletedEntity;
    }

    @Override
    protected void executeConfirmedAction() {
        this.viewContext.getCommonService().revertDeletions(TechId.createList((Collection)this.data), AsyncCallbackWithProgressBar.decorate(this.callback, this.viewContext.getMessage("revert_deletions_progress", new Object[0])));
    }

    @Override
    protected String createMessage() {
        if (this.deletedEntityOrNull != null) {
            String deletedEntity = String.valueOf(this.deletedEntityOrNull.getEntityKind().getDescription()) + " '" + this.deletedEntityOrNull.getCode() + "'";
            Deletion deletion = this.deletedEntityOrNull.getDeletion();
            String deletedBy = deletion.getRegistrator().toString();
            String deletionDate = DateRenderer.renderDate(deletion.getRegistrationDate(), "yyyy-MM-dd HH:mm:ss");
            String deletionReason = StringEscapeUtils.unescapeHtml(deletion.getReason());
            return this.viewContext.getMessage("revert_entity_deletion_confirmation_msg", deletedEntity, deletedBy, deletionDate, deletionReason);
        }
        return this.viewContext.getMessage("revert_deletions_confirmation_msg", ((List)this.data).size());
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(60);
        this.formPanel.setFieldWidth(180);
    }
}

