/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.IPrincipalProvider;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.common.spring.AbstractServiceWithLogger;
import ch.systemsx.cisd.openbis.generic.server.DisplaySettingsProvider;
import ch.systemsx.cisd.openbis.generic.server.IASyncAction;
import ch.systemsx.cisd.openbis.generic.server.SessionFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExpressionValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.plugin.DataSetServerPluginRegistry;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.SampleServerPluginRegistry;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.IRemoteHostValidator;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityVisitComparatorByTimeStamp;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityVisit;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.translator.GridCustomExpressionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonRolesTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.ServerUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractServer<T>
extends AbstractServiceWithLogger<T>
implements IServer {
    protected static ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 360L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static final String ETL_SERVER_USERNAME_PREFIX = "etlserver";
    @Resource(name="sample-plugin-registry")
    private SampleServerPluginRegistry sampleServerPluginRegistry;
    @Resource(name="data-set-plugin-registry")
    private DataSetServerPluginRegistry dataSetServerPluginRegistry;
    private ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin;
    private IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin;
    @Resource(name="session-manager")
    protected IOpenBisSessionManager sessionManager;
    @Resource(name="display-settings-provider")
    protected DisplaySettingsProvider displaySettingsProvider;
    @Resource(name="dao-factory")
    private IDAOFactory daoFactory;
    @Resource(name="dss-factory")
    private IDataStoreServiceFactory dssFactory;
    @Resource(name="remote-host-validator")
    private IRemoteHostValidator remoteHostValidator;
    @Resource(name="mail-client-parameters")
    protected MailClientParameters mailClientParameters;
    @Resource(name="propertyConfigurer")
    protected ExposablePropertyPlaceholderConfigurer configurer;
    @Resource(name="properties-batch-manager")
    private IPropertiesBatchManager propertiesBatchManager;
    private String userForAnonymousLogin;
    protected String CISDHelpdeskEmail;

    protected AbstractServer() {
        this.operationLog.info((Object)String.format("Creating new '%s' implementation: '%s'.", IServer.class.getSimpleName(), this.getClass().getName()));
    }

    protected AbstractServer(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager) {
        this();
        this.sessionManager = sessionManager;
        this.daoFactory = daoFactory;
        this.propertiesBatchManager = propertiesBatchManager;
    }

    protected AbstractServer(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin, IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin) {
        this(sessionManager, daoFactory, propertiesBatchManager);
        this.sampleTypeSlaveServerPlugin = sampleTypeSlaveServerPlugin;
        this.dataSetTypeSlaveServerPlugin = dataSetTypeSlaveServerPlugin;
    }

    public void setDisplaySettingsProvider(DisplaySettingsProvider displaySettingsProvider) {
        this.displaySettingsProvider = displaySettingsProvider;
    }

    public void setDssFactory(IDataStoreServiceFactory dssFactory) {
        this.dssFactory = dssFactory;
    }

    protected IPropertiesBatchManager getPropertiesBatchManager() {
        return this.propertiesBatchManager;
    }

    public final void setUserForAnonymousLogin(String userID) {
        this.userForAnonymousLogin = AbstractServer.isResolved(userID) ? userID : null;
    }

    public final void setCISDHelpdeskEmail(String cisdHelpdeskEmail) {
        this.CISDHelpdeskEmail = cisdHelpdeskEmail;
    }

    public final void setSampleTypeSlaveServerPlugin(ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin) {
        this.sampleTypeSlaveServerPlugin = sampleTypeSlaveServerPlugin;
    }

    public final void setDataSetTypeSlaveServerPlugin(IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin) {
        this.dataSetTypeSlaveServerPlugin = dataSetTypeSlaveServerPlugin;
    }

    protected final ISampleTypeSlaveServerPlugin getSampleTypeSlaveServerPlugin(SampleTypePE sampleType) {
        if (this.sampleTypeSlaveServerPlugin != null) {
            return this.sampleTypeSlaveServerPlugin;
        }
        return ((ISampleServerPlugin)this.sampleServerPluginRegistry.getPlugin(EntityKind.SAMPLE, sampleType)).getSlaveServer();
    }

    protected final IDataSetTypeSlaveServerPlugin getDataSetTypeSlaveServerPlugin(DataSetTypePE dataSetType) {
        if (this.dataSetTypeSlaveServerPlugin != null) {
            return this.dataSetTypeSlaveServerPlugin;
        }
        return ((IDataSetServerPlugin)this.dataSetServerPluginRegistry.getPlugin(EntityKind.DATA_SET, dataSetType)).getSlaveServer();
    }

    @Deprecated
    protected void permanentlyDeleteDataSets(Session session, IDataSetTable dataSetTable, List<String> dataSetCodes, String reason, boolean forceDisallowedTypes) {
        DataSetTypePE dataSetType;
        dataSetTable.loadByDataSetCodes(dataSetCodes, false, false);
        List<DataPE> dataSets = dataSetTable.getDataSets();
        if (this.atLeastOneOfDataSetsIsContainer(dataSets)) {
            List<TechId> ids = this.daoFactory.getDataDAO().listContainedDataSetsRecursively(TechId.createList(dataSetTable.getDataSets()));
            dataSetTable.loadByIds(ids);
            dataSets = dataSetTable.getDataSets();
        }
        LinkedHashMap<DataSetTypePE, ArrayList<DataPE>> groupedDataSets = new LinkedHashMap<DataSetTypePE, ArrayList<DataPE>>();
        DataSetTable.assertDatasetsAreDeletable(dataSets);
        DataSetTable.assertDatasetsWithDisallowedTypes(dataSets, forceDisallowedTypes);
        for (DataPE dataPE : dataSets) {
            dataSetType = dataPE.getDataSetType();
            ArrayList<DataPE> list = (ArrayList<DataPE>)groupedDataSets.get(dataSetType);
            if (list == null) {
                list = new ArrayList<DataPE>();
                groupedDataSets.put(dataSetType, list);
            }
            list.add(dataPE);
        }
        for (Map.Entry entry : groupedDataSets.entrySet()) {
            dataSetType = (DataSetTypePE)entry.getKey();
            IDataSetTypeSlaveServerPlugin plugin = this.getDataSetTypeSlaveServerPlugin(dataSetType);
            plugin.permanentlyDeleteDataSets(session, (List)entry.getValue(), reason, forceDisallowedTypes);
        }
    }

    private boolean atLeastOneOfDataSetsIsContainer(Collection<DataPE> dataSets) {
        for (DataPE dataSet : dataSets) {
            if (!dataSet.isContainer()) continue;
            return true;
        }
        return false;
    }

    private final RoleAssignmentPE createRoleAssigment(PersonPE registrator, PersonPE person, RoleWithHierarchy.RoleCode roleCode) {
        RoleAssignmentPE roleAssignmentPE = new RoleAssignmentPE();
        roleAssignmentPE.setDatabaseInstance(this.daoFactory.getHomeDatabaseInstance());
        roleAssignmentPE.setRegistrator(registrator);
        roleAssignmentPE.setRole(roleCode);
        person.addRoleAssignment(roleAssignmentPE);
        return roleAssignmentPE;
    }

    protected final PersonPE createPerson(Principal principal, PersonPE registrator, DisplaySettings defaultDisplaySettings) {
        PersonPE person = new PersonPE();
        person.setUserId(principal.getUserId());
        person.setFirstName(principal.getFirstName());
        person.setLastName(principal.getLastName());
        person.setEmail(principal.getEmail());
        person.setRegistrator(registrator);
        person.setDatabaseInstance(this.daoFactory.getHomeDatabaseInstance());
        person.setDisplaySettings(defaultDisplaySettings);
        person.setActive(true);
        try {
            this.daoFactory.getPersonDAO().createPerson(person);
        }
        catch (DataAccessException e) {
            throw new UserFailureException(e.getMessage(), e);
        }
        return person;
    }

    private final void updatePersonIfNecessary(PersonPE person, Principal principal) {
        boolean changed = false;
        if (this.updateNeeded(person.getEmail(), principal.getEmail())) {
            person.setEmail(principal.getEmail());
            changed = true;
        }
        if (this.updateNeeded(person.getFirstName(), principal.getFirstName())) {
            person.setFirstName(principal.getFirstName());
            changed = true;
        }
        if (this.updateNeeded(person.getLastName(), principal.getLastName())) {
            person.setLastName(principal.getLastName());
            changed = true;
        }
        if (changed) {
            try {
                this.daoFactory.getPersonDAO().updatePerson(person);
            }
            catch (DataAccessException e) {
                throw new UserFailureException(e.getMessage(), e);
            }
        }
    }

    private boolean updateNeeded(String currentValue, String newValue) {
        if (newValue == null) {
            return false;
        }
        return currentValue == null || !currentValue.equals(newValue);
    }

    protected final PersonPE getSystemUser() {
        return AbstractServer.getSystemUser(this.daoFactory.getPersonDAO().listPersons());
    }

    private static final PersonPE getSystemUser(List<PersonPE> persons) {
        for (PersonPE personPE : persons) {
            if (!personPE.isSystemUser()) continue;
            return personPE;
        }
        throw new IllegalStateException(String.format("No system user could be found in given list '%s'.", persons));
    }

    protected final ISessionManager<Session> getSessionManager() {
        return this.sessionManager;
    }

    protected final IDAOFactory getDAOFactory() {
        return this.daoFactory;
    }

    @Override
    public void checkSession(String sessionToken) throws InvalidSessionException {
        this.getSession(sessionToken);
    }

    protected Session getSession(String sessionToken) {
        assert (sessionToken != null) : "Unspecified session token";
        return this.getSessionManager().getSession(sessionToken);
    }

    @Override
    public final IAuthSession getAuthSession(String sessionToken) throws UserFailureException {
        return new SimpleSession((IAuthSession)this.sessionManager.getSession(sessionToken));
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    @Transactional(readOnly=true)
    public final void logout(String sessionToken) throws UserFailureException {
        try {
            this.sessionManager.closeSession(sessionToken);
            SessionFactory.cleanUpSessionOnDataStoreServers(sessionToken, this.daoFactory.getDataStoreDAO(), this.dssFactory);
        }
        catch (InvalidSessionException invalidSessionException) {}
    }

    @Override
    @Transactional(readOnly=true)
    public final void expireSession(String sessionToken) throws UserFailureException {
        try {
            this.sessionManager.expireSession(sessionToken);
            SessionFactory.cleanUpSessionOnDataStoreServers(sessionToken, this.daoFactory.getDataStoreDAO(), this.dssFactory);
        }
        catch (InvalidSessionException invalidSessionException) {}
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deactivatePersons(String sessionToken, List<String> personsCodes) {
        this.checkSession(sessionToken);
        for (String personCode : personsCodes) {
            PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(personCode);
            if (person == null) continue;
            IRoleAssignmentDAO roleAssignmenDAO = this.getDAOFactory().getRoleAssignmentDAO();
            person.setActive(false);
            person.clearAuthorizationGroups();
            ArrayList<RoleAssignmentPE> roleAssignments = new ArrayList<RoleAssignmentPE>(person.getRoleAssignments());
            for (RoleAssignmentPE roleAssignment : roleAssignments) {
                roleAssignmenDAO.deleteRoleAssignment(roleAssignment);
            }
            this.getDAOFactory().getPersonDAO().updatePerson(person);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public int countActivePersons(String sessionToken) {
        this.checkSession(sessionToken);
        return this.getDAOFactory().getPersonDAO().countActivePersons();
    }

    @Override
    public SessionContextDTO tryAuthenticateAnonymously() {
        if (this.userForAnonymousLogin == null) {
            return null;
        }
        PersonPE person = this.daoFactory.getPersonDAO().tryFindPersonByUserId(this.userForAnonymousLogin);
        if (person == null) {
            return null;
        }
        return this.tryToAuthenticate(this.sessionManager.tryToOpenSession(this.userForAnonymousLogin, new AuthenticatedPersonBasedPrincipalProvider(person)));
    }

    @Override
    public final SessionContextDTO tryAuthenticate(String user, String password) {
        return this.tryToAuthenticate(this.sessionManager.tryToOpenSession(user, password));
    }

    private SessionContextDTO tryToAuthenticate(String sessionToken) {
        Set<RoleAssignmentPE> roles;
        if (sessionToken == null) {
            return null;
        }
        Session session = (Session)this.sessionManager.getSession(sessionToken);
        List<PersonPE> persons = null;
        PersonPE person = this.daoFactory.getPersonDAO().tryFindPersonByUserId(session.getUserName());
        if (person == null) {
            persons = this.daoFactory.getPersonDAO().listPersons();
            PersonPE systemUser = AbstractServer.getSystemUser(persons);
            DisplaySettings defaultDisplaySettings = this.getDefaultDisplaySettings(sessionToken);
            person = this.createPerson(session.getPrincipal(), systemUser, defaultDisplaySettings);
            roles = Collections.emptySet();
        } else {
            this.updatePersonIfNecessary(person, session.getPrincipal());
            roles = person.getAllPersonRoles();
            HibernateUtils.initialize(roles);
        }
        if (session.tryGetPerson() == null) {
            session.setPerson(person);
            this.displaySettingsProvider.addDisplaySettingsForPerson(person);
        }
        if (roles.isEmpty()) {
            if (persons == null) {
                persons = this.daoFactory.getPersonDAO().listPersons();
            }
            if (this.isFirstLoggedUser(person, persons)) {
                this.grantRoleAtFirstLogin(persons, person, RoleWithHierarchy.RoleCode.ADMIN);
            } else if (this.isFirstLoggedETLServer(person, persons)) {
                this.grantRoleAtFirstLogin(persons, person, RoleWithHierarchy.RoleCode.ETL_SERVER);
            } else {
                this.authenticationLog.info((Object)String.format("User '%s' has no role assignments and thus is not permitted to login.", person.getUserId()));
                return null;
            }
        }
        if (!person.isActive()) {
            this.authenticationLog.info((Object)String.format("User '%s' has been deactivated and thus is not permitted to login.", person.getUserId()));
            return null;
        }
        this.removeNotExistingVisits(session);
        return this.asDTO(session);
    }

    private void removeNotExistingVisits(Session session) {
        if (session == null || session.tryGetPerson() == null) {
            return;
        }
        DisplaySettings settings = session.tryGetPerson().getDisplaySettings();
        Iterator<EntityVisit> iterator = settings.getVisits().iterator();
        boolean changed = false;
        while (iterator.hasNext()) {
            EntityVisit visit = iterator.next();
            EntityKind kind = EntityKind.valueOf(visit.getEntityKind());
            IEntityWithMetaprojects entity = null;
            switch (kind) {
                case DATA_SET: {
                    entity = this.daoFactory.getDataDAO().tryToFindDataSetByCode(visit.getIdentifier());
                    break;
                }
                case EXPERIMENT: {
                    entity = this.daoFactory.getExperimentDAO().tryGetByPermID(visit.getPermID());
                    break;
                }
                case MATERIAL: {
                    entity = this.daoFactory.getMaterialDAO().tryFindMaterial(MaterialIdentifier.tryParseIdentifier(visit.getIdentifier()));
                    break;
                }
                case SAMPLE: {
                    entity = this.daoFactory.getSampleDAO().tryToFindByPermID(visit.getPermID());
                }
            }
            if (entity != null) continue;
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.daoFactory.getPersonDAO().updatePerson(session.tryGetPerson());
        }
    }

    private void grantRoleAtFirstLogin(List<PersonPE> persons, PersonPE person, RoleWithHierarchy.RoleCode roleCode) {
        PersonPE systemUser = AbstractServer.getSystemUser(persons);
        if (systemUser.getRoleAssignments().isEmpty()) {
            RoleAssignmentPE roleAssignment = this.createRoleAssigment(systemUser, person, roleCode);
            this.daoFactory.getRoleAssignmentDAO().createRoleAssignment(roleAssignment);
        }
    }

    private boolean isFirstLoggedUser(PersonPE newPerson, List<PersonPE> persons) {
        if (this.isETLServerUserId(newPerson)) {
            return false;
        }
        for (PersonPE person : persons) {
            if (person.isSystemUser() || this.isETLServerUserId(person)) continue;
            return false;
        }
        return true;
    }

    private boolean isFirstLoggedETLServer(PersonPE person, List<PersonPE> persons) {
        if (!this.isETLServerUserId(person)) {
            return false;
        }
        for (PersonPE existingPerson : persons) {
            if (!this.isETLServerUserId(existingPerson)) continue;
            return false;
        }
        return true;
    }

    private boolean isETLServerUserId(PersonPE person) {
        return person.getUserId().startsWith(ETL_SERVER_USERNAME_PREFIX);
    }

    private SessionContextDTO asDTO(Session session) {
        SessionContextDTO result = new SessionContextDTO();
        PersonPE person = session.tryGetPerson();
        assert (person != null) : "cannot obtain the person which is logged in";
        result.setDisplaySettings(this.displaySettingsProvider.getRegularDisplaySettings(person));
        SpacePE homeGroup = person.getHomeSpace();
        result.setHomeGroupCode(homeGroup == null ? null : homeGroup.getCode());
        result.setSessionExpirationTime(session.getSessionExpirationTime());
        result.setSessionToken(session.getSessionToken());
        result.setUserName(session.getUserName());
        result.setUserEmail(session.getUserEmail());
        result.setAnonymous(session.isAnonymous());
        result.setUserPersonObject(PersonTranslator.translate(person));
        result.setUserPersonRoles(PersonRolesTranslator.translate(person.getAllPersonRoles()));
        return result;
    }

    @Override
    public SessionContextDTO tryGetSession(String sessionToken) {
        try {
            Session session = (Session)this.sessionManager.getSession(sessionToken);
            return this.asDTO(session);
        }
        catch (InvalidSessionException invalidSessionException) {
            return null;
        }
    }

    @Override
    public boolean isArchivingConfigured(String sessionToken) {
        List<DataStorePE> stores = this.daoFactory.getDataStoreDAO().listDataStores();
        for (DataStorePE store : stores) {
            if (!store.isArchiverConfigured()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDisplaySettings(String sessionToken, DisplaySettings displaySettings, int maxEntityVisits) {
        try {
            Session session;
            Session session2 = session = this.getSession(sessionToken);
            synchronized (session2) {
                PersonPE person = session.tryGetPerson();
                if (person != null) {
                    DisplaySettingsProvider displaySettingsProvider = this.displaySettingsProvider;
                    synchronized (displaySettingsProvider) {
                        if (maxEntityVisits >= 0) {
                            List<EntityVisit> visits = displaySettings.getVisits();
                            this.sortAndRemoveMultipleVisits(visits);
                            int i = visits.size() - 1;
                            while (i >= maxEntityVisits) {
                                visits.remove(i);
                                --i;
                            }
                        }
                        this.displaySettingsProvider.replaceRegularDisplaySettings(person, displaySettings);
                        this.getDAOFactory().getPersonDAO().updatePerson(person);
                    }
                }
            }
        }
        catch (InvalidSessionException invalidSessionException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDisplaySettings(String sessionToken, IDisplaySettingsUpdate displaySettingsUpdate) {
        if (displaySettingsUpdate == null) {
            throw new IllegalArgumentException("Display settings update cannot be null");
        }
        try {
            Session session;
            Session session2 = session = this.getSession(sessionToken);
            synchronized (session2) {
                PersonPE person = session.tryGetPerson();
                if (person != null) {
                    DisplaySettingsProvider displaySettingsProvider = this.displaySettingsProvider;
                    synchronized (displaySettingsProvider) {
                        DisplaySettings currentDisplaySettings = this.displaySettingsProvider.getCurrentDisplaySettings(person);
                        DisplaySettings newDisplaySettings = displaySettingsUpdate.update(currentDisplaySettings);
                        this.displaySettingsProvider.replaceCurrentDisplaySettings(person, newDisplaySettings);
                        this.getDAOFactory().getPersonDAO().updatePerson(person);
                    }
                }
            }
        }
        catch (InvalidSessionException invalidSessionException) {}
    }

    private void sortAndRemoveMultipleVisits(List<EntityVisit> visits) {
        Collections.sort(visits, new EntityVisitComparatorByTimeStamp());
        HashSet<String> permIds = new HashSet<String>();
        Iterator<EntityVisit> iterator = visits.iterator();
        while (iterator.hasNext()) {
            EntityVisit entityVisit = iterator.next();
            String permID = entityVisit.getPermID();
            if (permIds.contains(permID)) {
                iterator.remove();
            }
            permIds.add(permID);
        }
    }

    @Override
    public DisplaySettings getDefaultDisplaySettings(String sessionToken) {
        PersonPE systemUser = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId("system");
        if (systemUser == null) {
            throw new UserFailureException("Couldn't find system user with default settings in the DB.");
        }
        return systemUser.getDisplaySettings();
    }

    @Override
    public void changeUserHomeSpace(String sessionToken, TechId groupIdOrNull) {
        Session session = this.getSessionManager().getSession(sessionToken);
        PersonPE person = session.tryGetPerson();
        if (person != null) {
            SpacePE homeGroup = groupIdOrNull == null ? null : (SpacePE)this.getDAOFactory().getSpaceDAO().getByTechId(groupIdOrNull);
            person.setHomeSpace(homeGroup);
            this.getDAOFactory().getPersonDAO().updatePerson(person);
        }
    }

    @Override
    public void setBaseIndexURL(String sessionToken, String baseIndexURL) {
        Session session = this.getSessionManager().getSession(sessionToken);
        session.setBaseIndexURL(baseIndexURL);
    }

    @Override
    public String getBaseIndexURL(String sessionToken) {
        Session session = this.getSessionManager().getSession(sessionToken);
        return session.getBaseIndexURL();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExpressionValidator.class)
    public List<GridCustomColumn> listGridCustomColumns(String sessionToken, String gridId) {
        Session session = this.getSession(sessionToken);
        List<GridCustomColumnPE> columnPEs = this.getDAOFactory().getGridCustomColumnDAO().listColumns(gridId);
        ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
        List<GridCustomColumn> columns = GridCustomExpressionTranslator.GridCustomColumnTranslator.translate(columnPEs);
        ExpressionValidator validator = new ExpressionValidator();
        PersonPE currentPerson = session.tryGetPerson();
        for (GridCustomColumn column : columns) {
            if (!validator.isValid(currentPerson, column)) continue;
            result.add(column);
        }
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void setSessionUser(String sessionToken, String userID) {
        Session session = this.getSession(sessionToken);
        String remoteHost = session.getRemoteHost();
        if (!this.remoteHostValidator.isValidRemoteHost(remoteHost)) {
            throw new UserFailureException("It is not allowed to change the user from remote host " + remoteHost);
        }
        this.injectPerson(session, userID);
    }

    protected void injectPerson(Session session, String personID) {
        PersonPE person = this.daoFactory.getPersonDAO().tryFindPersonByUserId(personID);
        if (person == null) {
            throw new UserFailureException("Unknown user: " + personID);
        }
        HibernateUtils.initialize(person.getAllPersonRoles());
        session.setPerson(person);
        this.displaySettingsProvider.addDisplaySettingsForPerson(person);
    }

    protected void registerSamples(Session session, NewSamplesWithTypes newSamplesWithType, PersonPE registratorOrNull) {
        SampleType sampleType = (SampleType)newSamplesWithType.getEntityType();
        List<NewSample> newSamples = newSamplesWithType.getNewEntities();
        assert (sampleType != null) : "Unspecified sample type.";
        assert (newSamples != null) : "Unspecified new samples.";
        if (newSamples.size() == 0) {
            return;
        }
        AbstractServer.fillHomeSpace(newSamples, session.tryGetHomeGroupCode());
        ServerUtils.prevalidate(newSamples, "sample");
        String sampleTypeCode = sampleType.getCode();
        SampleTypePE sampleTypePE = this.getDAOFactory().getSampleTypeDAO().tryFindSampleTypeByCode(sampleTypeCode);
        if (sampleTypePE == null) {
            throw UserFailureException.fromTemplate("Sample type with code '%s' does not exist.", sampleTypeCode);
        }
        this.getPropertiesBatchManager().manageProperties(sampleTypePE, newSamples, registratorOrNull);
        this.getSampleTypeSlaveServerPlugin(sampleTypePE).registerSamples(session, newSamples, registratorOrNull);
    }

    protected static void fillHomeSpace(List<NewSample> samples, String homeSpaceOrNull) {
        if (homeSpaceOrNull == null) {
            return;
        }
        String spaceIdentifier = new SpaceIdentifier(homeSpaceOrNull).toString();
        for (NewSample sample : samples) {
            if (sample.getDefaultSpaceIdentifier() != null) continue;
            sample.setDefaultSpaceIdentifier(spaceIdentifier);
        }
    }

    protected void executeASync(final String userEmail, final IASyncAction action) {
        final MailClient mailClient = new MailClient(this.mailClientParameters);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                block5: {
                    StringWriter writer = new StringWriter();
                    boolean success = true;
                    Date startDate = new Date();
                    try {
                        try {
                            success = action.doAction(writer);
                        }
                        catch (RuntimeException e) {
                            AbstractServer.this.operationLog.error((Object)("Asynchronous action '" + action.getName() + "' failed. "), (Throwable)e);
                            success = false;
                            AbstractServer.this.sendEmail(mailClient, writer.toString(), AbstractServer.getSubject(action.getName(), startDate, success), userEmail);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        AbstractServer.this.sendEmail(mailClient, writer.toString(), AbstractServer.getSubject(action.getName(), startDate, success), userEmail);
                        throw throwable;
                    }
                    AbstractServer.this.sendEmail(mailClient, writer.toString(), AbstractServer.getSubject(action.getName(), startDate, success), userEmail);
                }
            }
        };
        executor.submit(task);
    }

    protected void sendEmail(IMailClient mailClient, String content, String subject, String ... recipient) {
        mailClient.sendMessage(subject, content, null, null, recipient);
    }

    private static String getSubject(String actionName, Date startDate, boolean success) {
        return AbstractServer.addDate(String.valueOf(actionName) + " " + (success ? "successfully performed" : "failed"), startDate);
    }

    private static String addDate(String subject, Date startDate) {
        return String.valueOf(subject) + " (initiated at " + startDate + ")";
    }

    static boolean isResolved(String name) {
        return StringUtils.isNotBlank((String)name) && !name.startsWith("${");
    }

    protected static final class AuthenticatedPersonBasedPrincipalProvider
    implements IPrincipalProvider {
        private final PersonPE person;

        AuthenticatedPersonBasedPrincipalProvider(PersonPE person) {
            this.person = person;
        }

        @Override
        public Principal tryToGetPrincipal(String userID) {
            Principal result = new Principal(this.person.getUserId(), this.person.getFirstName(), this.person.getLastName(), this.person.getEmail(), true);
            result.setAnonymous(true);
            return result;
        }
    }
}

