/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1;

import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.DisplaySettingsProvider;
import ch.systemsx.cisd.openbis.generic.server.api.v1.GeneralInformationChangingServiceLogger;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationChangingService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignmentsIds;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.NewVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.WebAppSettings;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="general-information-changing-api-server-v1")
public class GeneralInformationChangingService
extends AbstractServer<IGeneralInformationChangingService>
implements IGeneralInformationChangingService {
    public static final int MINOR_VERSION = 3;
    @Resource(name="common-server")
    private ICommonServer server;

    public GeneralInformationChangingService() {
    }

    GeneralInformationChangingService(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ICommonServer server) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.server = server;
    }

    @Override
    public IGeneralInformationChangingService createLogger(IInvocationLoggerContext context) {
        return new GeneralInformationChangingServiceLogger(this.sessionManager, context);
    }

    @Override
    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void updateSampleProperties(String sessionToken, long sampleID, Map<String, String> properties) {
        this.checkSession(sessionToken);
        EntityHelper.updateSampleProperties(this.server, sessionToken, new TechId(sampleID), properties);
    }

    @Override
    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    public void addUnofficialVocabularyTerm(String sessionToken, TechId vocabularyId, String code, String label, String description, Long previousTermOrdinal) {
        this.server.addUnofficialVocabularyTerm(sessionToken, vocabularyId, code, label, description, previousTermOrdinal);
    }

    @Override
    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    public void addUnofficialVocabularyTerm(String sessionToken, Long vocabularyId, NewVocabularyTerm term) {
        TechId vocabularyTechId = new TechId(vocabularyId);
        this.server.addUnofficialVocabularyTerm(sessionToken, vocabularyTechId, term.getCode(), term.getLabel(), term.getDescription(), term.getPreviousTermOrdinal());
    }

    @Override
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public WebAppSettings getWebAppSettings(String sessionToken, String webAppId) {
        Session session = this.getSession(sessionToken);
        return new WebAppSettings(webAppId, this.displaySettingsProvider.getWebAppSettings(session.getPerson(), webAppId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(readOnly=false)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void setWebAppSettings(String sessionToken, WebAppSettings webAppSettings) {
        block5: {
            try {
                Session session = this.getSession(sessionToken);
                PersonPE person = session.tryGetPerson();
                if (person == null) break block5;
                DisplaySettingsProvider displaySettingsProvider = this.displaySettingsProvider;
                synchronized (displaySettingsProvider) {
                    this.displaySettingsProvider.replaceWebAppSettings(person, webAppSettings);
                    this.getDAOFactory().getPersonDAO().updatePerson(person);
                }
            }
            catch (InvalidSessionException invalidSessionException) {}
        }
    }

    @Override
    @Transactional(readOnly=false)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public Metaproject createMetaproject(String sessionToken, String name, String descriptionOrNull) {
        Metaproject registration = new Metaproject();
        registration.setName(name);
        registration.setDescription(descriptionOrNull);
        return this.server.registerMetaproject(sessionToken, registration);
    }

    @Override
    @Transactional(readOnly=false)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public Metaproject updateMetaproject(String sessionToken, IMetaprojectId metaprojectId, String name, String descriptionOrNull) {
        Metaproject update = new Metaproject();
        update.setName(name);
        update.setDescription(descriptionOrNull);
        return this.server.updateMetaproject(sessionToken, metaprojectId, update);
    }

    @Override
    @Transactional(readOnly=false)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void deleteMetaproject(String sessionToken, IMetaprojectId metaprojectId) {
        this.server.deleteMetaproject(sessionToken, metaprojectId, null);
    }

    @Override
    @Transactional(readOnly=false)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void addToMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToAdd) {
        this.server.addToMetaproject(sessionToken, metaprojectId, assignmentsToAdd);
    }

    @Override
    @Transactional(readOnly=false)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void removeFromMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToRemove) {
        this.server.removeFromMetaproject(sessionToken, metaprojectId, assignmentsToRemove);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }
}

