/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.EntityTypeLabelUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.PropertiesUtil;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MaterialComponentUtils {
    private static final String MATERIAL_ID_DICT_MSG = "Id";

    public static String getMaterialFullName(Material material, boolean captalizeFirstLetter) {
        return String.valueOf(MaterialComponentUtils.getMaterialTypeAsTitle(material, captalizeFirstLetter)) + " " + MaterialComponentUtils.getMaterialName(material);
    }

    public static String getMaterialName(Material material) {
        String geneSymbol;
        if (material.getEntityType().getCode().equalsIgnoreCase("GENE") && (geneSymbol = PropertiesUtil.tryFindProperty(material, "GENE_SYMBOLS")) != null) {
            return geneSymbol;
        }
        return material.getCode();
    }

    public static String getMaterialTypeAsTitle(Material material, boolean captalizeFirstLetter) {
        String materialTypeCode = material.getMaterialType().getCode();
        return EntityTypeLabelUtils.formatAsTitle(materialTypeCode, captalizeFirstLetter);
    }

    public static IDisposableComponent createExperimentViewer(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithProperties experiment, String headingText, IDisposableComponent gridComponent) {
        return MaterialComponentUtils.createViewer(viewContext, experiment, headingText, gridComponent, null, new String[0]);
    }

    public static IDisposableComponent createMaterialViewer(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithProperties material, String headingText, IDisposableComponent gridComponent) {
        Map<String, String> additionalProperties = MaterialComponentUtils.createAdditionalMaterialProperties(material);
        return MaterialComponentUtils.createViewer(viewContext, material, headingText, gridComponent, additionalProperties, MaterialComponentUtils.getExcludedMatrialProperties());
    }

    public static String[] getExcludedMatrialProperties() {
        return new String[]{"GENE_SYMBOLS"};
    }

    public static Map<String, String> createAdditionalMaterialProperties(IEntityInformationHolderWithProperties material) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put(MATERIAL_ID_DICT_MSG, material.getCode());
        return additionalProperties;
    }

    private static IDisposableComponent createViewer(IViewContext<IScreeningClientServiceAsync> viewContext, IEntityInformationHolderWithProperties entity, String headingTextOrNull, final IDisposableComponent gridComponent, Map<String, String> additionalPropertiesOrNull, String ... excludedPropertyCodes) {
        final LayoutContainer panel = new LayoutContainer();
        panel.setLayout((Layout)new BorderLayout());
        if (headingTextOrNull != null) {
            MaterialComponentUtils.addHeader(panel, viewContext, headingTextOrNull, entity, additionalPropertiesOrNull, excludedPropertyCodes);
        }
        panel.add((Widget)gridComponent.getComponent(), (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        return new IDisposableComponent(){

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications) {
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return new DatabaseModificationKind[0];
            }

            @Override
            public Component getComponent() {
                return panel;
            }

            @Override
            public void dispose() {
                gridComponent.dispose();
            }
        };
    }

    private static void addHeader(LayoutContainer parentPanel, IViewContext<IScreeningClientServiceAsync> viewContext, String headingText, IEntityInformationHolderWithProperties entity, Map<String, String> additionalPropertiesOrNull, String ... excludedPropertyCodes) {
        LayoutContainer panel = new LayoutContainer();
        panel.setLayout((Layout)new RowLayout());
        panel.setScrollMode(Style.Scroll.AUTOY);
        Html headingWidget = PropertiesUtil.createHeaderTitle(headingText);
        panel.add((Widget)headingWidget, (LayoutData)PropertiesUtil.createHeaderTitleLayoutData());
        LayoutContainer propertiesPanel = new LayoutContainer();
        propertiesPanel.setLayout((Layout)new RowLayout());
        int propsHeight = PropertiesUtil.addProperties(entity, propertiesPanel, additionalPropertiesOrNull, excludedPropertyCodes);
        panel.add((Widget)propertiesPanel, (LayoutData)new RowData(1.0, (double)propsHeight));
        int headersHeight = 25;
        int totalHeight = propsHeight + headersHeight;
        BorderLayoutData layoutData = new BorderLayoutData(Style.LayoutRegion.NORTH, (float)totalHeight);
        layoutData.setMargins(PropertiesUtil.createHeaderInfoMargin());
        parentPanel.add((Widget)panel, (LayoutData)layoutData);
    }
}

