/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.server.util.FileUploadFeedbackProvider;
import ch.systemsx.cisd.cifex.server.util.ThresholdProgressListener;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileUploadFeedback;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;

final class FileUploadProgressListener
extends ThresholdProgressListener {
    private static final long THRESHOLD = 204800L;
    private final HttpSession httpSession;
    private final List<String> formIndexedPathnamesAndNulls;
    private final long start;

    FileUploadProgressListener(HttpSession httpSession, List<String> formIndexedPathnamesAndNulls) {
        super(204800L);
        this.httpSession = httpSession;
        this.formIndexedPathnamesAndNulls = formIndexedPathnamesAndNulls;
        this.start = System.currentTimeMillis();
    }

    private final FileUploadFeedback createFileUploadFeedback(long bytesRead, long contentLength, int items) {
        FileUploadFeedback feedback = new FileUploadFeedback();
        feedback.setBytesRead(bytesRead);
        feedback.setContentLength(contentLength);
        int item = items - 1;
        if (this.formIndexedPathnamesAndNulls.get(item) != null) {
            feedback.setFileName(FilenameUtils.getName((String)this.formIndexedPathnamesAndNulls.get(item)));
        }
        feedback.setTimeLeft(this.createTimeLeft(bytesRead, contentLength));
        return feedback;
    }

    private final long createTimeLeft(long bytesRead, long contentLength) {
        long timeSpent = System.currentTimeMillis() - this.start;
        if (contentLength < 0L || bytesRead == 0L || timeSpent == 0L) {
            return Long.MAX_VALUE;
        }
        long remainingBytes = contentLength - bytesRead;
        return timeSpent * remainingBytes / bytesRead;
    }

    @Override
    public final void hasProgressed(long bytesRead, long contentLength, int items) {
        FileUploadFeedbackProvider feedbackProvider = (FileUploadFeedbackProvider)this.httpSession.getAttribute("upload-feedback-queue");
        assert (feedbackProvider != null) : "Provider must not be null.";
        feedbackProvider.set(this.createFileUploadFeedback(bytesRead, contentLength, items));
    }
}

