/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.server.business.AbstractEMailBuilder;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.mail.IMailClient;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class EMailBuilderForUpdateUser
extends AbstractEMailBuilder {
    private static final String UPDATED_ACCOUNT_EMAIL_SUBJECT_LINE = "updated-account-email-subject";
    private static final String UPDATED_ACCOUNT_EMAIL_TEMPLATE_FILE_NAME = "etc/updated-account-email.template";
    private final UserDTO updateUser;

    public EMailBuilderForUpdateUser(IMailClient mailClient, UserDTO registrator, UserDTO user) {
        super(mailClient, registrator, user.getEmail());
        this.updateUser = user;
        this.setFullName(this.updateUser.getUserFullName());
    }

    @Override
    protected String createContent() {
        return this.createContent(UPDATED_ACCOUNT_EMAIL_TEMPLATE_FILE_NAME);
    }

    @Override
    protected String createSubject() {
        return StringUtils.capitalize((String)((String)this.emailDict.get(UPDATED_ACCOUNT_EMAIL_SUBJECT_LINE)));
    }

    @Override
    protected String getUserCode() {
        return this.updateUser.getUserCode();
    }

    @Override
    protected Date tryGetExpirationDate() {
        return this.updateUser.getExpirationDate();
    }

    @Override
    protected void addToDict(Properties emailProps, DateFormat dateFormat) {
        if (this.updateUser.isAdmin()) {
            this.emailDict.put("account-type", emailProps.getProperty("account-type-admin"));
            this.emailDict.put("account-type2", emailProps.getProperty("account-type-admin2"));
        } else if (this.updateUser.isPermanent()) {
            this.emailDict.put("account-type", emailProps.getProperty("account-type-regular"));
            this.emailDict.put("account-type2", emailProps.getProperty("account-type-regular2"));
        } else {
            this.emailDict.put("account-type", emailProps.getProperty("account-type-temp"));
            this.emailDict.put("account-type2", emailProps.getProperty("account-type-temp2"));
        }
    }
}

