/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.dbmigration.DBMigrationEngine;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import eu.basysbio.cisd.dss.StringArrayMapper;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.lemnik.eodsql.QueryTool;

public class DBUtils {
    public static final String DATABASE_VERSION = "008";
    private static final String DATABASE_PROPERTIES_PREFIX = "database.";
    private static ConcurrentHashMap<Properties, DatabaseConfigurationContext> dbContexts;

    static {
        QueryTool.getTypeMap().put(String[].class, new StringArrayMapper());
        dbContexts = new ConcurrentHashMap();
    }

    public static synchronized DatabaseConfigurationContext getOrCreateDBContext(Properties properties) {
        DatabaseConfigurationContext dbContext = dbContexts.get(properties);
        if (dbContext == null) {
            dbContext = DBUtils.createAndInitDBContext(properties);
            dbContexts.put(properties, dbContext);
        }
        return dbContext;
    }

    public static DatabaseConfigurationContext createAndInitDBContext(Properties properties) {
        DatabaseConfigurationContext dbContext = DBUtils.createDBContext(properties);
        DBUtils.init(dbContext);
        return dbContext;
    }

    public static DatabaseConfigurationContext createDBContext(Properties properties) {
        ExtendedProperties dbProps = ExtendedProperties.getSubset((Properties)properties, (String)DATABASE_PROPERTIES_PREFIX, (boolean)true);
        DatabaseConfigurationContext context = (DatabaseConfigurationContext)BeanUtils.createBean(DatabaseConfigurationContext.class, (Object)dbProps);
        if (context.getBasicDatabaseName() == null) {
            throw new EnvironmentFailureException("db basic name not specified in " + dbProps);
        }
        if (context.getDatabaseEngineCode() == null) {
            throw new EnvironmentFailureException("db engine code not specified in " + dbProps);
        }
        DatabaseConfigurationContext dbContext = context;
        return dbContext;
    }

    public static void init(DatabaseConfigurationContext context) {
        DBMigrationEngine.createOrMigrateDatabaseAndGetScriptProvider((DatabaseConfigurationContext)context, (String)DATABASE_VERSION);
    }

    private DBUtils() {
    }
}

