/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.time.DateFormatThreadLocal;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TimeSeriesAndTimePointDataSetHandler
implements IDataSetHandler {
    private static final String CIFEX_DIR_ENDING = ".dir";
    @Private
    static final String HELPDESK_EMAIL = "helpdesk.openbis.basysbio@bsse.ethz.ch";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, TimeSeriesAndTimePointDataSetHandler.class);
    private static final FilenameFilter LCA_MIC_TIME_SERIES_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("LCA_MIC_TIME_SERIES");
        }
    };
    private final IDataSetHandler delegator;
    private final IMailClient mailClient;
    private final ITimeProvider timeProvider;

    public TimeSeriesAndTimePointDataSetHandler(Properties parentProperties, IDataSetHandler delegator) {
        this.delegator = delegator;
        this.mailClient = new MailClient(parentProperties);
        this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
    }

    @Private
    TimeSeriesAndTimePointDataSetHandler(IDataSetHandler delegator, IMailClient mailClient, ITimeProvider timeProvider) {
        this.delegator = delegator;
        this.mailClient = mailClient;
        this.timeProvider = timeProvider;
    }

    public List<DataSetInformation> handleDataSet(File dataSet) {
        boolean successful;
        ArrayList<DataSetInformation> dataSetInfos = new ArrayList<DataSetInformation>();
        List result = this.delegator.handleDataSet(dataSet);
        dataSetInfos.addAll(result);
        boolean bl = successful = !result.isEmpty();
        if (successful) {
            try {
                DataSetInformation dataSetInformation = (DataSetInformation)result.get(0);
                MessageBuilder builder = new MessageBuilder(dataSetInformation.tryGetUploadingUserEmail(), this.timeProvider);
                builder.setDataSetFileName(dataSet);
                File[] files = dataSet.getParentFile().listFiles(LCA_MIC_TIME_SERIES_FILE_FILTER);
                this.handleDerivedDataSets(files, TypeOfDerivedDataSet.LCA_MIC_TIME_SERIES, this.delegator, dataSetInfos, builder);
                DataSetType dataSetType = dataSetInformation.getDataSetType();
                boolean lcaMicTimeSeries = dataSetType.getCode().equals("LCA_MIC_TIME_SERIES");
                builder.logSendEMailAndHandlerError(operationLog, this.mailClient, !lcaMicTimeSeries);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Exception can't be handled properly any more.", ex);
            }
        }
        return dataSetInfos;
    }

    private void handleDerivedDataSets(File[] files, TypeOfDerivedDataSet type, IDataSetHandler handler, List<DataSetInformation> dataSetInfos, MessageBuilder builder) {
        if (files != null && files.length > 0) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Starting registration of " + files.length + " " + type.name + " data sets."));
            }
            builder.setNumberOfExpectedDerivedDataSets(type, files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                List result = handler.handleDataSet(file);
                dataSetInfos.addAll(result);
                if (!result.isEmpty()) {
                    builder.addDerivedDataSetCode(this.getDataSetCode(result));
                }
                ++n2;
            }
        }
    }

    private String getDataSetCode(List<DataSetInformation> result) {
        return result.get(0).getDataSetCode();
    }

    private static final class MessageBuilder {
        private final String userEMail;
        private final ITimeProvider timeProvider;
        private String dataSetFileName;
        private int numberOfDerivedDataSets;
        private int count;
        private TypeOfDerivedDataSet type;

        MessageBuilder(String userEMail, ITimeProvider timeProvider) {
            this.userEMail = userEMail;
            this.timeProvider = timeProvider;
        }

        void setDataSetFileName(File dataSet) {
            this.dataSetFileName = dataSet.getName();
            if (this.dataSetFileName.endsWith(TimeSeriesAndTimePointDataSetHandler.CIFEX_DIR_ENDING)) {
                int until = this.dataSetFileName.length() - TimeSeriesAndTimePointDataSetHandler.CIFEX_DIR_ENDING.length();
                this.dataSetFileName = this.dataSetFileName.substring(0, until);
            }
        }

        void setNumberOfExpectedDerivedDataSets(TypeOfDerivedDataSet type, int numberOfDerivedDataSets) {
            this.type = type;
            this.numberOfDerivedDataSets = numberOfDerivedDataSets;
        }

        void addDerivedDataSetCode(String code) {
            ++this.count;
        }

        void logSendEMailAndHandlerError(Logger logger, IMailClient mailClient, boolean sendEMail) {
            if (this.count < this.numberOfDerivedDataSets) {
                int numberOfFailures = this.numberOfDerivedDataSets - this.count;
                operationLog.error((Object)(String.valueOf(numberOfFailures) + " " + this.type.name + " data sets couldn't be registered."));
                if (sendEMail) {
                    String subject = "BaSysBio: Failed uploading of data set '" + this.dataSetFileName + "'";
                    String timeStamp = ((SimpleDateFormat)DateFormatThreadLocal.DATE_FORMAT.get()).format(new Date(this.timeProvider.getTimeInMilliseconds()));
                    String message = "Uploading of data set '" + this.dataSetFileName + "' failed because " + numberOfFailures + " of " + this.numberOfDerivedDataSets + " " + this.type.name + " data sets couldn't be registered.\n\n" + "Please, contact the help desk for support: " + TimeSeriesAndTimePointDataSetHandler.HELPDESK_EMAIL + "\n(Time stamp of failure: " + timeStamp + ")";
                    mailClient.sendMessage(subject, message, null, null, new String[]{this.userEMail, TimeSeriesAndTimePointDataSetHandler.HELPDESK_EMAIL});
                }
                throw new UserFailureException("Not all data sets could be registered. For more details see error messages in the log.");
            }
            if (this.count > 0 && operationLog.isInfoEnabled()) {
                operationLog.info((Object)(String.valueOf(this.count) + " " + this.type.name + " data sets have been registered."));
            }
            if (sendEMail) {
                String subject = "BaSysBio: Successful uploading of data set '" + this.dataSetFileName + "'";
                String message = "The data set '" + this.dataSetFileName + "' has been successfully uploaded and registered in openBIS.";
                mailClient.sendMessage(subject, message, null, null, new String[]{this.userEMail});
            }
        }
    }

    private static enum TypeOfDerivedDataSet {
        TIME_POINT("time point"),
        LCA_MIC_TIME_SERIES("LCA MIC time series");

        private final String name;

        private TypeOfDerivedDataSet(String name) {
            this.name = name;
        }
    }
}

