/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.etlserver.DelegatingStorageProcessorWithDropbox;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.yeastx.etl.AbstractDatasetDropboxHandlerYeastX;
import ch.systemsx.cisd.yeastx.etl.DataSetInformationYeastX;
import ch.systemsx.cisd.yeastx.etl.MLConversionType;
import java.io.File;
import java.util.Properties;

public class StorageProcessorWithDropboxes
extends DelegatingStorageProcessorWithDropbox {
    public static final String DROPBOX_EICML_INCOMING_DIRECTORY_PROPERTY = "eicml-dropbox-dir";
    public static final String DROPBOX_FIAML_INCOMING_DIRECTORY_PROPERTY = "fiaml-dropbox-dir";

    public StorageProcessorWithDropboxes(Properties properties) {
        super(properties);
    }

    public IPostRegistrationDatasetHandler createPostRegistrationDataSetHandler() {
        return new DatasetDropboxHandler(this.properties);
    }

    private static class DatasetDropboxHandler
    extends AbstractDatasetDropboxHandlerYeastX {
        private static final long serialVersionUID = 1L;
        private final File eicmlDropboxOrNull;
        private final File fiamlDropboxOrNull;

        public DatasetDropboxHandler(Properties properties) {
            super(properties);
            this.eicmlDropboxOrNull = this.tryGetDirectory(StorageProcessorWithDropboxes.DROPBOX_EICML_INCOMING_DIRECTORY_PROPERTY, properties);
            this.fiamlDropboxOrNull = this.tryGetDirectory(StorageProcessorWithDropboxes.DROPBOX_FIAML_INCOMING_DIRECTORY_PROPERTY, properties);
        }

        protected File tryGetDropboxDir(File originalData, DataSetInformation dataSetInformation) {
            DataSetInformationYeastX info = (DataSetInformationYeastX)dataSetInformation;
            MLConversionType conversion = info.getConversion();
            if (conversion == MLConversionType.EICML) {
                return this.eicmlDropboxOrNull;
            }
            if (conversion == MLConversionType.FIAML) {
                return this.fiamlDropboxOrNull;
            }
            return null;
        }
    }
}

