/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.xml.XMLInfraStructure;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static String XML_SCHEMA_XSD_URL = "http://www.w3.org/2001/XMLSchema.xsd";
    public static String XSLT_XSD_URL = "http://www.w3.org/2007/schema-for-xslt20.xsd";
    public static String XML_SCHEMA_XSD_FILE_RESOURCE = "/XMLSchema.xsd";
    public static String XSLT_XSD_FILE_RESOURCE = "/schema-for-xslt20.xsd";
    public static final Integer INDENTATION = 2;
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final Map<String, Transformer> cachedTransformers = new HashMap<String, Transformer>();

    public static Document parseXmlDocument(String value) {
        DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
        dBF.setNamespaceAware(true);
        InputSource is = new InputSource(new StringReader(value));
        try {
            return dBF.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw UserFailureException.fromTemplate("Provided value:\n\n%s\n\nisn't a well formed XML document. %s", value, e.getMessage());
        }
    }

    public static String serializeDocument(Document document) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", INDENTATION.toString());
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(document), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static void validate(Document document, String xmlSchema) throws SAXException, IOException {
        XmlUtils.validate(document, XMLInfraStructure.createSchema(new StreamSource(new StringReader(xmlSchema))));
    }

    public static void validate(Document document, URL schemaURL) throws SAXException, IOException {
        XmlUtils.validate(document, XMLInfraStructure.createSchema(schemaURL));
    }

    public static void validate(Document document, File schemaFile) throws SAXException, IOException {
        XmlUtils.validate(document, XMLInfraStructure.createSchema(schemaFile));
    }

    public static void validate(Document document, Schema schema) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    public static String transform(String xslt, String xmlString) {
        Transformer transformer = XmlUtils.getTransformer(xslt);
        StreamSource source = new StreamSource(new StringReader(xmlString));
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        return writer.toString();
    }

    private static Transformer getTransformer(String xslt) {
        try {
            Transformer transformer = cachedTransformers.get(xslt);
            if (transformer == null) {
                transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(new StringReader(xslt)));
                cachedTransformers.put(xslt, transformer);
            }
            return transformer;
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }
}

