/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppContext;
import java.io.Serializable;
import java.util.Map;

public class WebApp
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String code;
    private String label;
    private Integer sorting;
    private String[] contexts;
    private Map<EntityKind, String[]> entityTypes;

    private WebApp() {
    }

    public WebApp(String code) {
        this(code, null, null, null, null);
    }

    public WebApp(String code, String label, Integer sorting, String[] contexts, Map<EntityKind, String[]> entityTypes) {
        if (code == null) {
            throw new IllegalArgumentException("Code cannot be null");
        }
        this.code = code;
        this.label = label;
        this.sorting = sorting;
        this.contexts = contexts;
        this.entityTypes = entityTypes;
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public Integer getSorting() {
        return this.sorting;
    }

    public String[] getContexts() {
        return this.contexts;
    }

    public Map<EntityKind, String[]> getEntityTypes() {
        return this.entityTypes;
    }

    public boolean matchesContext(WebAppContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        return this.matches(this.contexts, context.getName());
    }

    public boolean matchesEntity(EntityKind entityKind, BasicEntityType entityType) {
        if (entityKind == null) {
            throw new IllegalArgumentException("Entity kind cannot be null");
        }
        if (entityType == null) {
            throw new IllegalArgumentException("Entity type cannot be null");
        }
        if (this.entityTypes == null || this.entityTypes.get(entityKind) == null) {
            return false;
        }
        return this.matches(this.entityTypes.get(entityKind), entityType.getCode());
    }

    private boolean matches(String[] configuredValues, String checkedValue) {
        if (configuredValues == null) {
            return false;
        }
        String[] stringArray = configuredValues;
        int n = configuredValues.length;
        int n2 = 0;
        while (n2 < n) {
            String configuredValue = stringArray[n2];
            if (checkedValue.matches(configuredValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

