/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.core.rules.RulesEngineImpl;
import java.util.HashSet;
import java.util.Set;

public class AndCondition
extends Condition {
    private static final long serialVersionUID = -5854944262991488370L;
    protected RulesEngineImpl rulesEngineImpl;
    protected Set<Condition> nestedConditions = new HashSet<Condition>();

    public AndCondition(RulesEngineImpl rulesEngineImpl) {
        this.rulesEngineImpl = rulesEngineImpl;
    }

    public AndCondition(RulesEngineImpl rulesEngineImpl, Condition ... operands) {
        this.rulesEngineImpl = rulesEngineImpl;
        Condition[] conditionArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            this.nestedConditions.add(condition);
            ++n2;
        }
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() <= 0) {
            throw new Exception("Missing nested element in condition \"" + this.getId() + "\"");
        }
        for (IXMLElement element : xmlcondition.getChildren()) {
            this.nestedConditions.add(this.rulesEngineImpl.instanciateCondition(element));
        }
    }

    @Override
    public boolean isTrue() {
        boolean result = true;
        for (Condition condition : this.nestedConditions) {
            condition.setInstalldata(this.getInstallData());
            boolean bl = result = result && condition.isTrue();
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>");
        for (Condition condition : this.nestedConditions) {
            details.append(condition.getDependenciesDetails());
            details.append("</li> AND <li>");
        }
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        for (Condition condition : this.nestedConditions) {
            IXMLElement left = this.rulesEngineImpl.createConditionElement(condition, conditionRoot);
            condition.makeXMLData(left);
            conditionRoot.addChild(left);
        }
    }
}

