/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.base.IzPanel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.panels.userinput.UserInputFileFilter;
import com.izforge.izpack.panels.userinput.processorclient.StringInputProcessingClient;
import com.izforge.izpack.panels.userinput.validator.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileInputField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4673684743657328492L;
    InstallerFrame parentFrame;
    IzPanel parent;
    List<ValidatorContainer> validators;
    JTextField filetxt;
    JButton browseBtn;
    String set;
    int size;
    GUIInstallData installDataGUI;
    String fileExtension;
    String fileExtensionDescription;
    boolean allowEmpty;
    protected static final int INVALID = 0;
    protected static final int EMPTY = 1;

    public FileInputField(IzPanel parent, GUIInstallData installDataGUI, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig) {
        this(parent, installDataGUI, directory, set, size, validatorConfig, null, null);
    }

    public FileInputField(IzPanel parent, GUIInstallData installDataGUI, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, String fileExt, String fileExtDesc) {
        this.parent = parent;
        this.parentFrame = parent.getInstallerFrame();
        this.installDataGUI = installDataGUI;
        this.validators = validatorConfig;
        this.set = set;
        this.size = size;
        this.fileExtension = fileExt;
        this.fileExtensionDescription = fileExtDesc;
        this.initialize();
    }

    private void initialize() {
        this.filetxt = new JTextField(this.set, this.size);
        this.filetxt.setCaretPosition(0);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints fileTextConstraint = new GridBagConstraints();
        GridBagConstraints fileButtonConstraint = new GridBagConstraints();
        fileTextConstraint.gridx = 0;
        fileTextConstraint.gridy = 0;
        fileTextConstraint.anchor = 17;
        fileTextConstraint.insets = new Insets(0, 0, 0, 5);
        fileButtonConstraint.gridx = 1;
        fileButtonConstraint.gridy = 0;
        fileButtonConstraint.anchor = 17;
        this.browseBtn = ButtonFactory.createButton(this.installDataGUI.getLangpack().getString("UserInputPanel.search.browse"), this.installDataGUI.buttonsHColor);
        this.browseBtn.addActionListener(this);
        this.add((Component)this.filetxt, fileTextConstraint);
        this.add((Component)this.browseBtn, fileButtonConstraint);
    }

    public void setFile(String filename) {
        this.filetxt.setText(filename);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.browseBtn) {
            Debug.trace("Show dirchooser");
            String initialPath = ".";
            if (this.filetxt.getText() != null) {
                initialPath = this.filetxt.getText();
            }
            JFileChooser filechooser = new JFileChooser(initialPath);
            this.prepareFileChooser(filechooser);
            if (filechooser.showOpenDialog(this.parentFrame) == 0) {
                String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
                this.filetxt.setText(selectedFile);
                Debug.trace("Setting current file chooser directory to: " + selectedFile);
            }
        }
    }

    protected void prepareFileChooser(JFileChooser filechooser) {
        filechooser.setFileSelectionMode(0);
        if (this.fileExtension != null && this.fileExtensionDescription != null) {
            UserInputFileFilter fileFilter = new UserInputFileFilter();
            fileFilter.setFileExt(this.fileExtension);
            fileFilter.setFileExtDesc(this.fileExtensionDescription);
            filechooser.setFileFilter(fileFilter);
        }
    }

    public File getSelectedFile() {
        File result = null;
        if (this.filetxt.getText() != null) {
            result = new File(this.filetxt.getText());
        }
        return result;
    }

    protected void showMessage(int k) {
        if (k == 0) {
            this.showMessage("file.notfile");
        } else if (k == 1) {
            this.showMessage("file.nofile");
        }
    }

    protected void showMessage(String messageType) {
        JOptionPane.showMessageDialog(this.parentFrame, this.parentFrame.getLangpack().getString("UserInputPanel." + messageType + ".message"), this.parentFrame.getLangpack().getString("UserInputPanel." + messageType + ".caption"), 2);
    }

    public boolean validateField() {
        boolean result = false;
        String input = this.filetxt.getText();
        if (this.allowEmpty && (input == null || input.length() == 0)) {
            result = true;
        } else if (input != null) {
            if (input.startsWith("~")) {
                String home = System.getProperty("user.home");
                input = String.valueOf(home) + input.substring(1);
            }
            File file = new File(input).getAbsoluteFile();
            input = file.toString();
            this.filetxt.setText(input);
            if (!this._validate(file)) {
                result = false;
                this.showMessage(0);
            } else {
                StringInputProcessingClient processingClient = new StringInputProcessingClient(input, this.validators);
                boolean success = processingClient.validate();
                if (!success) {
                    JOptionPane.showMessageDialog(this.parentFrame, processingClient.getValidationMessage(), this.parentFrame.getLangpack().getString("UserInputPanel.error.caption"), 2);
                }
                result = success;
            }
        } else {
            this.showMessage(1);
        }
        return result;
    }

    protected boolean _validate(File file) {
        return file.isFile();
    }

    public boolean isAllowEmptyInput() {
        return this.allowEmpty;
    }

    public void setAllowEmptyInput(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }
}

