/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.config.ConfigFileTask;
import com.izforge.izpack.util.config.SingleConfigurableTask;
import java.io.File;
import java.io.IOException;
import org.ini4j.Ini;

public class SingleIniFileTask
extends ConfigFileTask {
    @Override
    protected void readSourceConfigurable() throws Exception {
        if (this.oldFile != null) {
            try {
                if (!this.oldFile.exists()) {
                    Debug.log("INI file " + this.oldFile.getAbsolutePath() + " to patch from could not be found, no patches will be applied");
                    return;
                }
                Debug.log("Loading INI file: " + this.oldFile.getAbsolutePath());
                this.fromConfigurable = new Ini(this.oldFile);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void readConfigurable() throws Exception {
        if (this.newFile != null) {
            try {
                if (!this.newFile.exists()) {
                    throw new Exception("Reference file " + this.newFile.getAbsolutePath() + " for patch cannot be found");
                }
                Debug.log("Loading INI file: " + this.newFile.getAbsolutePath());
                this.configurable = new Ini(this.newFile);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        } else {
            this.configurable = new Ini();
        }
    }

    @Override
    protected void writeConfigurable() throws Exception {
        try {
            if (!this.toFile.exists()) {
                if (this.createConfigurable) {
                    File parent = this.toFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    Debug.log("Creating empty INI file: " + this.toFile.getAbsolutePath());
                    this.toFile.createNewFile();
                } else {
                    Debug.log("INI file " + this.toFile.getAbsolutePath() + " did not exist and is not allowed to be created");
                    return;
                }
            }
            Ini ini = (Ini)this.configurable;
            ini.setFile(this.toFile);
            ini.setComment(this.getComment());
            ini.store();
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
        if (this.cleanup && this.oldFile.exists() && !this.oldFile.delete()) {
            Debug.log("File " + this.oldFile + " could not be cleant up");
        }
    }

    @Override
    protected SingleConfigurableTask.Entry filterEntryFromXML(IXMLElement parent, SingleConfigurableTask.Entry entry) {
        entry.setSection(parent.getAttribute("section"));
        entry.setKey(parent.getAttribute("key"));
        entry.setValue(parent.getAttribute("value"));
        return entry;
    }
}

