/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Role;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonObject(value="SpaceWithProjectsAndRoleAssignments")
public class SpaceWithProjectsAndRoleAssignments
implements ICodeHolder,
Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private List<Project> projects = new ArrayList<Project>();
    @JsonProperty
    private Map<String, Set<Role>> rolesPerUser = new HashMap<String, Set<Role>>();

    public SpaceWithProjectsAndRoleAssignments(String code) {
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Unspecified code.");
        }
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void add(Project project) {
        this.projects.add(project);
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void add(String user, Role role) {
        Set<Role> roles = this.rolesPerUser.get(user);
        if (roles == null) {
            roles = new HashSet<Role>();
            this.rolesPerUser.put(user, roles);
        }
        roles.add(role);
    }

    public Set<Role> getRoles(String userID) {
        Set<Role> set = this.rolesPerUser.get(userID);
        return set == null ? Collections.emptySet() : set;
    }

    @JsonIgnore
    public Set<String> getUsers() {
        return this.rolesPerUser.keySet();
    }

    private SpaceWithProjectsAndRoleAssignments() {
    }

    private Map<String, Set<Role>> getRolesPerUser() {
        return this.rolesPerUser;
    }

    private void setRolesPerUser(Map<String, Set<Role>> rolesPerUser) {
        this.rolesPerUser = rolesPerUser;
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setProjects(List<Project> projects) {
        this.projects = projects;
    }
}

