/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import java.io.Serializable;

@JsonObject(value="Attachment")
public class Attachment
implements Serializable,
Comparable<Attachment> {
    private static final long serialVersionUID = 1L;
    private IObjectId attachmentHolderId;
    private String fileName;
    private int version;
    private String title;
    private String description;
    private EntityRegistrationDetails registrationDetails;
    private String downloadLink;

    public Attachment(AttachmentInitializer initializer) {
        this.setAttachmentHolderId(initializer.getAttachmentHolderId());
        this.setFileName(initializer.getFileName());
        this.setVersion(initializer.getVersion());
        this.setTitle(initializer.getTitle());
        this.setDescription(initializer.getDescription());
        this.setRegistrationDetails(initializer.getRegistrationDetails());
        this.setDownloadLink(initializer.getDownloadLink());
    }

    public IObjectId getAttachmentHolderId() {
        return this.attachmentHolderId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public String getDownloadLink() {
        return this.downloadLink;
    }

    private Attachment() {
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void setVersion(int version) {
        this.version = version;
    }

    private void setTitle(String title) {
        this.title = StringUtils.isBlank((String)title) ? "" : title;
    }

    private void setDescription(String description) {
        this.description = StringUtils.isBlank((String)description) ? "" : description;
    }

    private void setAttachmentHolderId(IObjectId attachmentHolderId) {
        this.attachmentHolderId = attachmentHolderId;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    private void setDownloadLink(String downloadLink) {
        this.downloadLink = downloadLink;
    }

    @Override
    public int compareTo(Attachment o) {
        int byFile = this.getFileName().compareTo(o.getFileName());
        return byFile == 0 ? this.version - o.version : 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attachment other = (Attachment)obj;
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return "Attachment [fileName=" + this.fileName + ", version=" + this.version + ", title=" + this.title + ", description=" + this.description + ", registrationDate=" + this.registrationDetails.getRegistrationDate() + ", userFirstName=" + this.registrationDetails.getUserFirstName() + ", userLastName=" + this.registrationDetails.getUserLastName() + ", userEmail=" + this.registrationDetails.getUserEmail() + ", userId=" + this.registrationDetails.getUserId() + ", downloadLink=" + this.downloadLink + "]";
    }

    public static class AttachmentInitializer {
        private IObjectId attachmentHolderId;
        private String fileName;
        private int version;
        private String title;
        private String description;
        private EntityRegistrationDetails registrationDetails;
        private String downloadLink;

        public IObjectId getAttachmentHolderId() {
            return this.attachmentHolderId;
        }

        public void setAttachmentHolderId(IObjectId attachmentHolderId) {
            this.attachmentHolderId = attachmentHolderId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }

        public String getDownloadLink() {
            return this.downloadLink;
        }

        public void setDownloadLink(String downloadLink) {
            this.downloadLink = downloadLink;
        }
    }
}

