/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import java.util.Arrays;

public class DataSetUploadInfo {
    private static final String PARENT_SEPARATOR = "|";
    private static final String SEPARATOR = ",";
    private String sample;
    private String experiment;
    private String[] parents;
    private String dataSetType;
    private String fileType;

    public DataSetUploadInfo() {
    }

    public DataSetUploadInfo(String sample, String experiment, String[] parents, String dataSetType, String fileType) {
        this.setSample(sample);
        this.setExperiment(experiment);
        this.setParents(parents);
        this.setDataSetType(dataSetType);
        this.setFileType(fileType);
    }

    public String getSample() {
        return this.sample;
    }

    public void setSample(String sample) {
        this.sample = sample;
    }

    public String getDataSetType() {
        return this.dataSetType;
    }

    public void setDataSetType(String dataSetType) {
        this.dataSetType = dataSetType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public void setExperiment(String experiment) {
        this.experiment = experiment;
    }

    public String[] getParents() {
        return this.parents;
    }

    public void setParents(String[] parents) {
        this.parents = parents;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.sample != null) {
            builder.append("sample:").append(this.sample).append(", ");
        }
        if (this.experiment != null) {
            builder.append("experiment:").append(this.experiment).append(", ");
        }
        if (this.parents != null && this.parents.length > 0) {
            builder.append("parent data set:").append(Arrays.asList(this.parents)).append(", ");
        }
        builder.append("data set type:").append(this.dataSetType).append(", ");
        builder.append("file type:").append(this.fileType);
        return builder.toString();
    }

    public static class DataSetUploadInfoHelper {
        public static String encodeAsCifexComment(DataSetUploadInfo info) {
            String[] commentElements = new String[CommentElements.values().length];
            commentElements[CommentElements.SAMPLE.ordinal()] = info.getSample();
            commentElements[CommentElements.EXPERIMENT.ordinal()] = info.getExperiment();
            commentElements[CommentElements.PARENTS.ordinal()] = DataSetUploadInfoHelper.tryEncodeParentsAsString(info);
            commentElements[CommentElements.DATA_SET_TYPE.ordinal()] = info.getDataSetType();
            commentElements[CommentElements.FILE_TYPE.ordinal()] = info.getFileType();
            StringBuilder commentBuilder = new StringBuilder();
            String[] stringArray = commentElements;
            int n = commentElements.length;
            int n2 = 0;
            while (n2 < n) {
                String el = stringArray[n2];
                commentBuilder.append(el);
                commentBuilder.append(DataSetUploadInfo.SEPARATOR);
                ++n2;
            }
            return DataSetUploadInfoHelper.cutOffLastSeparator(commentBuilder, DataSetUploadInfo.SEPARATOR);
        }

        public static DataSetUploadInfo extractFromCifexComment(String comment) {
            String[] commentElements = comment.split(DataSetUploadInfoHelper.asEscapedRegexp(DataSetUploadInfo.SEPARATOR));
            DataSetUploadInfo result = new DataSetUploadInfo();
            result.setSample(DataSetUploadInfoHelper.nullify(commentElements[CommentElements.SAMPLE.ordinal()]));
            result.setExperiment(DataSetUploadInfoHelper.nullify(commentElements[CommentElements.EXPERIMENT.ordinal()]));
            result.setParents(DataSetUploadInfoHelper.tryExtractParentsFromString(DataSetUploadInfoHelper.nullify(commentElements[CommentElements.PARENTS.ordinal()])));
            result.setDataSetType(commentElements[CommentElements.DATA_SET_TYPE.ordinal()]);
            result.setFileType(commentElements[CommentElements.FILE_TYPE.ordinal()]);
            return result;
        }

        private static String nullify(String string) {
            return string.equals("null") ? null : string;
        }

        private static String[] tryExtractParentsFromString(String parents) {
            return parents == null ? null : parents.split(DataSetUploadInfoHelper.asEscapedRegexp(DataSetUploadInfo.PARENT_SEPARATOR));
        }

        private static String tryEncodeParentsAsString(DataSetUploadInfo info) {
            if (info.getParents() == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            String[] stringArray = info.getParents();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String parent = stringArray[n2];
                sb.append(parent);
                sb.append(DataSetUploadInfo.PARENT_SEPARATOR);
                ++n2;
            }
            return DataSetUploadInfoHelper.cutOffLastSeparator(sb, DataSetUploadInfo.PARENT_SEPARATOR);
        }

        private static String asEscapedRegexp(String str) {
            return "\\Q" + str + "\\E";
        }

        private static String cutOffLastSeparator(StringBuilder builder, String sep) {
            if (builder.length() == 0) {
                return "";
            }
            assert (builder.lastIndexOf(sep) == builder.length() - sep.length());
            return builder.substring(0, builder.length() - sep.length());
        }

        static enum CommentElements {
            SAMPLE,
            EXPERIMENT,
            PARENTS,
            DATA_SET_TYPE,
            FILE_TYPE;

        }
    }
}

