/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.util.JsonPropertyUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="Sample")
public final class Sample
implements Serializable,
IIdentifierHolder,
IIdHolder {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String spaceCode;
    private String permId;
    private String code;
    private String identifier;
    private String experimentIdentifierOrNull;
    private Long sampleTypeId;
    private String sampleTypeCode;
    private HashMap<String, String> properties;
    private EntityRegistrationDetails registrationDetails;
    private EnumSet<SampleFetchOption> retrievedFetchOptions;
    private List<Reference> parentReferences = Collections.emptyList();
    private List<Sample> parents;
    private List<Reference> childReferences = Collections.emptyList();
    private List<Sample> children;
    private boolean isStub;
    private List<Metaproject> metaprojects;

    public Sample(SampleInitializer initializer) {
        InitializingChecks.checkValidLong(initializer.getId(), "Unspecified id.");
        this.id = initializer.getId();
        this.spaceCode = initializer.getSpaceCode();
        InitializingChecks.checkValidString(initializer.getPermId(), "Unspecified permanent id.");
        this.permId = initializer.getPermId();
        this.retrievedFetchOptions = initializer.getRetrievedFetchOptions();
        if (initializer.isStub) {
            this.isStub = true;
        } else {
            InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
            this.code = initializer.getCode();
            InitializingChecks.checkValidString(initializer.getIdentifier(), "Unspecified identifier.");
            this.identifier = initializer.getIdentifier();
            this.experimentIdentifierOrNull = initializer.getExperimentIdentifierOrNull();
            InitializingChecks.checkValidLong(initializer.getSampleTypeId(), "Unspecified sample type id.");
            this.sampleTypeId = initializer.getSampleTypeId();
            InitializingChecks.checkValidString(initializer.getSampleTypeCode(), "Unspecified sample type code.");
            this.sampleTypeCode = initializer.getSampleTypeCode();
            this.properties = initializer.getProperties();
            this.metaprojects = initializer.getMetaprojects();
            InitializingChecks.checkValidRegistrationDetails(initializer.getRegistrationDetails(), "Unspecified entity registration details.");
            this.registrationDetails = initializer.getRegistrationDetails();
            if (initializer.parentReferences != null) {
                this.parentReferences = initializer.parentReferences;
            } else {
                this.parents = initializer.getParents();
            }
            if (initializer.childReferences != null) {
                this.childReferences = initializer.childReferences;
            } else {
                this.children = initializer.getChildren();
            }
        }
    }

    @Override
    @JsonIgnore
    public Long getId() {
        return this.id;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public String getPermId() {
        return this.permId;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getExperimentIdentifierOrNull() {
        return this.experimentIdentifierOrNull;
    }

    @JsonIgnore
    public Long getSampleTypeId() {
        return this.sampleTypeId;
    }

    public String getSampleTypeCode() {
        return this.sampleTypeCode;
    }

    @JsonIgnore
    public Map<String, String> getProperties() throws IllegalArgumentException {
        if (this.getRetrievedFetchOptions().contains(SampleFetchOption.PROPERTIES)) {
            return Collections.unmodifiableMap(this.properties);
        }
        throw new IllegalArgumentException("Properties were not retrieved for sample " + this.getIdentifier() + ".");
    }

    @JsonIgnore
    public List<Metaproject> getMetaprojects() throws IllegalArgumentException {
        if (this.getRetrievedFetchOptions().contains(SampleFetchOption.METAPROJECTS)) {
            return Collections.unmodifiableList(this.metaprojects);
        }
        throw new IllegalArgumentException("Metaprojects were not retrieved for sample " + this.getIdentifier() + ".");
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public EnumSet<SampleFetchOption> getRetrievedFetchOptions() {
        return this.retrievedFetchOptions;
    }

    @JsonIgnore
    public List<Sample> getChildren() throws IllegalArgumentException {
        if (this.getRetrievedFetchOptions().contains(SampleFetchOption.CHILDREN)) {
            if (this.children == null) {
                this.children = new ArrayList<Sample>();
                for (Reference reference : this.childReferences) {
                    Sample child = reference.resolve();
                    if (child == null) continue;
                    this.children.add(child);
                }
                this.childReferences = null;
            }
            return Collections.unmodifiableList(this.children);
        }
        throw new IllegalArgumentException("Children were not retrieved for sample " + this.getIdentifier() + ".");
    }

    @JsonIgnore
    public List<Sample> getParents() throws IllegalArgumentException {
        if (this.getRetrievedFetchOptions().contains(SampleFetchOption.PARENTS)) {
            if (this.parents == null) {
                this.parents = new ArrayList<Sample>();
                for (Reference reference : this.parentReferences) {
                    Sample parent = reference.resolve();
                    if (parent == null) continue;
                    this.parents.add(parent);
                }
                this.parentReferences = null;
            }
            return Collections.unmodifiableList(this.parents);
        }
        throw new IllegalArgumentException("Parents were not retrieved for sample " + this.getIdentifier() + ".");
    }

    public boolean isStub() {
        return this.isStub;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        Sample other = (Sample)obj;
        builder.append(this.getId(), other.getId());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getId());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.isStub()) {
            builder.append("STUB");
            builder.append(this.getPermId());
        } else {
            builder.append(this.getIdentifier());
            builder.append(this.getSampleTypeCode());
            if (this.retrievedFetchOptions.contains(SampleFetchOption.PROPERTIES)) {
                builder.append(this.getProperties());
            } else {
                builder.append("properties=?");
            }
            if (this.retrievedFetchOptions.contains(SampleFetchOption.PARENTS)) {
                builder.append("parents", this.getParents());
            } else {
                builder.append("parents=?");
            }
            if (this.retrievedFetchOptions.contains(SampleFetchOption.CHILDREN)) {
                builder.append("children", this.getChildren());
            } else {
                builder.append("children=?");
            }
        }
        return builder.toString();
    }

    private Sample() {
    }

    @JsonIgnore
    private void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="id")
    private String getIdAsString() {
        return JsonPropertyUtil.toStringOrNull(this.id);
    }

    private void setIdAsString(String id) {
        this.id = JsonPropertyUtil.toLongOrNull(id);
    }

    private void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    private void setPermId(String permId) {
        this.permId = permId;
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    private void setExperimentIdentifierOrNull(String experimentIdentifierOrNull) {
        this.experimentIdentifierOrNull = experimentIdentifierOrNull;
    }

    @JsonIgnore
    private void setSampleTypeId(Long sampleTypeId) {
        this.sampleTypeId = sampleTypeId;
    }

    @JsonProperty(value="sampleTypeId")
    private String getSampleTypeIdAsString() {
        return JsonPropertyUtil.toStringOrNull(this.sampleTypeId);
    }

    private void setSampleTypeIdAsString(String sampleTypeId) {
        this.sampleTypeId = JsonPropertyUtil.toLongOrNull(sampleTypeId);
    }

    private void setSampleTypeCode(String sampleTypeCode) {
        this.sampleTypeCode = sampleTypeCode;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getPropertiesJson() {
        return this.retrievedFetchOptions.contains(SampleFetchOption.PROPERTIES) ? this.properties : null;
    }

    @JsonProperty(value="properties")
    private void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="metaprojects")
    public List<Metaproject> getMetaprojectsJson() {
        return this.retrievedFetchOptions.contains(SampleFetchOption.METAPROJECTS) ? this.metaprojects : null;
    }

    @JsonProperty(value="metaprojects")
    private void setMetaprojectsJson(List<Metaproject> metaprojects) {
        this.metaprojects = metaprojects;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    private void setRetrievedFetchOptions(EnumSet<SampleFetchOption> fetchOptions) {
        this.retrievedFetchOptions = fetchOptions;
    }

    @JsonProperty(value="children")
    public List<Sample> getChildrenJson() {
        return this.retrievedFetchOptions.contains(SampleFetchOption.CHILDREN) ? this.children : null;
    }

    @JsonProperty(value="parents")
    public List<Sample> getParentsJson() {
        return this.retrievedFetchOptions.contains(SampleFetchOption.PARENTS) ? this.parents : null;
    }

    @JsonProperty(value="parents")
    private void setParents(List<Sample> parents) {
        this.parents = parents;
    }

    @JsonProperty(value="children")
    private void setChildren(List<Sample> children) {
        this.children = children;
    }

    private void setStub(boolean isStub) {
        this.isStub = isStub;
    }

    private static class Reference {
        private final Long id;
        private final Map<Long, Sample> repository;

        Reference(Long id, Map<Long, Sample> repository) {
            this.id = id;
            this.repository = repository;
        }

        Sample resolve() {
            return this.repository.get(this.id);
        }
    }

    public static final class SampleInitializer {
        private Long id;
        private String spaceCode;
        private String permId;
        private String code;
        private String identifier;
        private String experimentIdentifierOrNull;
        private Long sampleTypeId;
        private String sampleTypeCode;
        private HashMap<String, String> properties = new HashMap();
        private List<Metaproject> metaprojects = new ArrayList<Metaproject>();
        private EntityRegistrationDetails registrationDetails;
        private EnumSet<SampleFetchOption> retrievedFetchOptions = EnumSet.noneOf(SampleFetchOption.class);
        private List<Reference> parentReferences;
        private List<Sample> parents = Collections.emptyList();
        private List<Reference> childReferences;
        private List<Sample> children = Collections.emptyList();
        private boolean isStub;

        public void setId(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public void setSpaceCode(String spaceCode) {
            this.spaceCode = spaceCode;
        }

        public String getSpaceCode() {
            return this.spaceCode;
        }

        public void setPermId(String permId) {
            this.permId = permId;
        }

        public String getPermId() {
            return this.permId;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getExperimentIdentifierOrNull() {
            return this.experimentIdentifierOrNull;
        }

        public void setExperimentIdentifierOrNull(String experimentIdentifierOrNull) {
            this.experimentIdentifierOrNull = experimentIdentifierOrNull;
        }

        public void setSampleTypeId(Long sampleTypeId) {
            this.sampleTypeId = sampleTypeId;
        }

        public Long getSampleTypeId() {
            return this.sampleTypeId;
        }

        public void setSampleTypeCode(String sampleTypeCode) {
            this.sampleTypeCode = sampleTypeCode;
        }

        public String getSampleTypeCode() {
            return this.sampleTypeCode;
        }

        public HashMap<String, String> getProperties() {
            return this.properties;
        }

        public void putProperty(String propCode, String value) {
            this.properties.put(propCode, value);
        }

        public List<Metaproject> getMetaprojects() {
            return this.metaprojects;
        }

        public void addMetaproject(Metaproject metaproject) {
            this.metaprojects.add(metaproject);
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }

        public void setRetrievedFetchOptions(EnumSet<SampleFetchOption> retrievedFetchOptions) {
            this.retrievedFetchOptions = retrievedFetchOptions == null ? EnumSet.noneOf(SampleFetchOption.class) : retrievedFetchOptions;
        }

        public EnumSet<SampleFetchOption> getRetrievedFetchOptions() {
            return this.retrievedFetchOptions;
        }

        public void setParents(List<Sample> parents) {
            this.parents = parents == null ? new ArrayList() : parents;
        }

        public List<Sample> getParents() {
            return this.parents;
        }

        public List<Sample> getChildren() {
            return this.children;
        }

        public void setChildren(List<Sample> children) {
            this.children = children == null ? new ArrayList() : children;
        }

        public void setParentReferences(List<Long> parentIDs, Map<Long, Sample> repository) {
            this.parentReferences = new ArrayList<Reference>();
            for (Long parentID : parentIDs) {
                this.parentReferences.add(new Reference(parentID, repository));
            }
        }

        public void setChildReferences(List<Long> childIDs, Map<Long, Sample> repository) {
            this.childReferences = new ArrayList<Reference>();
            for (Long childID : childIDs) {
                this.childReferences.add(new Reference(childID, repository));
            }
        }

        public void setStub(boolean isStub) {
            this.isStub = isStub;
        }
    }
}

