/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageTransformationInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@JsonObject(value="ImageChannel")
public class ImageChannel
implements Serializable,
Comparable<ImageChannel> {
    private static final long serialVersionUID = 1L;
    private String code;
    private String label;
    @JsonProperty
    private String description;
    @JsonProperty
    private Integer wavelength;
    private List<ImageTransformationInfo> transformations;

    public ImageChannel(String code, String label) {
        this.code = code;
        this.label = label;
        this.description = null;
        this.wavelength = null;
        this.transformations = Collections.emptyList();
    }

    public ImageChannel(String code, String label, String description, Integer wavelength, List<ImageTransformationInfo> transformations) {
        this.code = code;
        this.label = label;
        this.description = description;
        this.wavelength = wavelength;
        this.transformations = Collections.unmodifiableList(transformations);
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public String tryGetDescription() {
        return this.description;
    }

    public Integer tryGetWavelength() {
        return this.wavelength;
    }

    public List<ImageTransformationInfo> getTransformations() {
        return this.transformations;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageChannel other = (ImageChannel)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public String toString() {
        return "ImageChannel [code=" + this.code + ", label=" + this.label + ", description=" + this.description + ", wavelength=" + this.wavelength + ", transformations=" + this.transformations + "]";
    }

    @Override
    public int compareTo(ImageChannel imageChannel) {
        return this.code.compareTo(imageChannel.code);
    }

    private ImageChannel() {
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setLabel(String label) {
        this.label = label;
    }

    private String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private Integer getWavelength() {
        return this.wavelength;
    }

    private void setWavelength(Integer wavelength) {
        this.wavelength = wavelength;
    }

    private void setTransformations(List<ImageTransformationInfo> transformations) {
        this.transformations = transformations;
    }
}

