/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class PathPrefixPrepender {
    private final File absolutePathsDirectoryOrNull;
    private final File relativePathsDirectoryOrNull;
    private final String prefixForAbsolutePaths;
    private final String prefixForRelativePaths;

    public PathPrefixPrepender(String prefixForAbsolutePathsOrNull, String prefixForRelativePathsOrNull) throws ConfigurationFailureException {
        this.prefixForAbsolutePaths = PathPrefixPrepender.defaultString(prefixForAbsolutePathsOrNull);
        this.absolutePathsDirectoryOrNull = PathPrefixPrepender.tryCreateFile(this.prefixForAbsolutePaths, "absolute");
        this.prefixForRelativePaths = PathPrefixPrepender.preparePrefix(PathPrefixPrepender.defaultString(prefixForRelativePathsOrNull));
        this.relativePathsDirectoryOrNull = PathPrefixPrepender.tryCreateFile(this.prefixForRelativePaths, "relative");
    }

    private static final String defaultString(String path) {
        return StringUtils.defaultString(path).trim();
    }

    private static final String preparePrefix(String pathPrefix) {
        assert (pathPrefix != null) : "Unspecified path prefix.";
        if (pathPrefix.length() == 0) {
            return "";
        }
        if (pathPrefix.endsWith("/")) {
            return pathPrefix;
        }
        return String.valueOf(pathPrefix) + "/";
    }

    private static final File tryCreateFile(String prefix, String type) throws ConfigurationFailureException {
        assert (prefix != null) : "Unspecified path prefix.";
        if (prefix.length() > 0) {
            File file = new File(prefix);
            String response = FileUtilities.checkDirectoryFullyAccessible(file, String.valueOf(type) + " prefix path");
            if (response != null) {
                throw new ConfigurationFailureException(response);
            }
            return file;
        }
        return null;
    }

    public final File tryGetDirectoryForAbsolutePaths() {
        return this.absolutePathsDirectoryOrNull;
    }

    public final File tryGetDirectoryForRelativePaths() {
        return this.relativePathsDirectoryOrNull;
    }

    public final String addPrefixTo(String path) {
        assert (path != null) : "Undefined path.";
        return String.valueOf(FilenameUtils.getPrefixLength((String)path) > 0 ? this.prefixForAbsolutePaths : this.prefixForRelativePaths) + path;
    }
}

