/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ExampleImageTransformerFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DataSetCodeAndWellPositions;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageViewer {
    public static void main(String[] args) throws Exception {
        String serviceURL = args[0];
        String sessionToken = args[1];
        String channel = args[2];
        HashMap<String, DataSetCodeAndWellPositions> dataSets = new HashMap<String, DataSetCodeAndWellPositions>();
        int i = 3;
        while (i < args.length) {
            DataSetCodeAndWellPositions dw = new DataSetCodeAndWellPositions(args[i]);
            dataSets.put(dw.getDataSetCode(), dw);
            ++i;
        }
        JFrame frame = new JFrame("Image Viewer");
        frame.setDefaultCloseOperation(2);
        Container contentPane = frame.getContentPane();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        contentPane.add(content);
        ImageSize thumbnailSize = new ImageSize(100, 60);
        try {
            IScreeningOpenbisServiceFacade facade = ScreeningOpenbisServiceFacadeFactory.INSTANCE.tryToCreate(sessionToken, serviceURL);
            List<IDatasetIdentifier> dsIdentifiers = facade.getDatasetIdentifiers(new ArrayList<String>(dataSets.keySet()));
            for (IDatasetIdentifier identifier : dsIdentifiers) {
                content.add(new JLabel("Images for data set " + identifier.getDatasetCode()));
                JPanel imagePanel = new JPanel();
                imagePanel.setLayout(new BoxLayout(imagePanel, 0));
                content.add(imagePanel);
                List<WellPosition> wellPositions = ((DataSetCodeAndWellPositions)dataSets.get(identifier.getDatasetCode())).getWellPositions();
                List<byte[]> imageBytes = facade.loadImages(identifier, wellPositions, channel, thumbnailSize);
                for (byte[] bytes : imageBytes) {
                    imagePanel.add(new JLabel(new ImageIcon(bytes)));
                }
            }
            String pattern = channel.equals("Merged Channels") ? "brg" : "gbr";
            facade.saveImageTransformerFactory(dsIdentifiers, channel, new ExampleImageTransformerFactory(pattern));
            IImageTransformerFactory factory = facade.getImageTransformerFactoryOrNull(dsIdentifiers, channel);
            System.out.println("Image Transformer Factory: " + factory);
        }
        catch (Exception ex) {
            content.add(new JLabel(ex.toString()));
            throw ex;
        }
        frame.pack();
        frame.setVisible(true);
    }
}

