/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.cli;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jline.ConsoleReader;
import org.apache.commons.lang.StringUtils;

public class ConsoleClientArguments {
    @Option(name="u", longName="username", usage="User login name")
    protected String username = "";
    @Option(name="p", longName="password", usage="User login password")
    protected String password = "";
    @Option(name="h", longName="help", skipForExample=true)
    protected boolean isHelp = false;
    @Argument
    protected List<String> arguments = new ArrayList<String>();

    public boolean isHelp() {
        return this.isHelp;
    }

    public void setHelp(boolean isHelp) {
        this.isHelp = isHelp;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public final boolean isComplete() {
        if (this.isHelp) {
            return true;
        }
        if (!this.allAdditionalMandatoryArgumentsPresent()) {
            return false;
        }
        if (StringUtils.isBlank((String)this.username)) {
            try {
                UsernameAndPasswordReader reader = new UsernameAndPasswordReader();
                this.username = reader.readUsername();
                this.password = reader.readPassword();
                if (StringUtils.isBlank((String)this.username)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (StringUtils.isBlank((String)this.password)) {
            try {
                this.password = new UsernameAndPasswordReader().readPassword();
                if (StringUtils.isBlank((String)this.password)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    protected boolean allAdditionalMandatoryArgumentsPresent() {
        return true;
    }

    private static class UsernameAndPasswordReader {
        private final ConsoleReader consoleReader = new ConsoleReader();

        private UsernameAndPasswordReader() throws IOException {
        }

        private String readUsername() throws IOException {
            return this.consoleReader.readLine("User: ");
        }

        private String readPassword() throws IOException {
            return this.consoleReader.readLine("Password: ", Character.valueOf('*'));
        }
    }
}

