/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import java.util.ArrayList;
import java.util.List;

public class TableModelAppender {
    private boolean first = true;
    private List<TableModelColumnHeader> headers = new ArrayList<TableModelColumnHeader>();
    private List<TableModelRow> rows = new ArrayList<TableModelRow>();

    public void append(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Table model cannot be null");
        }
        if (this.first) {
            if (tableModel.getHeader() != null) {
                this.headers.addAll(tableModel.getHeader());
            }
            if (tableModel.getRows() != null) {
                this.rows.addAll(tableModel.getRows());
            }
            this.first = false;
        } else {
            this.checkColumnCount(tableModel);
            this.checkColumnTypes(tableModel);
            this.rows.addAll(tableModel.getRows());
        }
    }

    private void checkColumnCount(TableModel tableModel) {
        int appendedCount;
        int expectedCount = this.headers.size();
        int n = appendedCount = tableModel.getHeader() != null ? tableModel.getHeader().size() : 0;
        if (expectedCount != appendedCount) {
            throw new TableModelWithDifferentColumnCountException(expectedCount, appendedCount);
        }
    }

    private void checkColumnTypes(TableModel tableModel) {
        ArrayList<DataTypeCode> expectedTypes = new ArrayList<DataTypeCode>();
        ArrayList<DataTypeCode> appendedTypes = new ArrayList<DataTypeCode>();
        for (TableModelColumnHeader expectedHeader : this.headers) {
            expectedTypes.add(expectedHeader.getDataType());
        }
        for (TableModelColumnHeader appendedHeader : tableModel.getHeader()) {
            appendedTypes.add(appendedHeader.getDataType());
        }
        if (!expectedTypes.equals(appendedTypes)) {
            throw new TableModelWithDifferentColumnTypesException(expectedTypes, appendedTypes);
        }
    }

    public TableModel toTableModel() {
        return new TableModel(this.headers, this.rows);
    }

    public static class IllegalTableModelException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static class TableModelWithDifferentColumnCountException
    extends IllegalTableModelException {
        private static final long serialVersionUID = 1L;
        private int expectedColumnCount;
        private int appendedColumnCount;

        public TableModelWithDifferentColumnCountException(int expectedColumnCount, int appendedColumnCount) {
            this.expectedColumnCount = expectedColumnCount;
            this.appendedColumnCount = appendedColumnCount;
        }

        public int getExpectedColumnCount() {
            return this.expectedColumnCount;
        }

        public int getAppendedColumnCount() {
            return this.appendedColumnCount;
        }
    }

    public static class TableModelWithDifferentColumnTypesException
    extends IllegalTableModelException {
        private static final long serialVersionUID = 1L;
        private List<DataTypeCode> expectedColumnTypes;
        private List<DataTypeCode> appendedColumnTypes;

        public TableModelWithDifferentColumnTypesException(List<DataTypeCode> expectedColumnTypes, List<DataTypeCode> appendedColumnTypes) {
            this.expectedColumnTypes = expectedColumnTypes;
            this.appendedColumnTypes = appendedColumnTypes;
        }

        public List<DataTypeCode> getExpectedColumnTypes() {
            return this.expectedColumnTypes;
        }

        public List<DataTypeCode> getAppendedColumnTypes() {
            return this.appendedColumnTypes;
        }
    }
}

