/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingStatement;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Logger;

class MonitoringPoolingDataSource
extends PoolingDataSource {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, MonitoringPoolingDataSource.class);
    private static final Logger notifyLog = LogFactory.getLogger(LogCategory.NOTIFY, MonitoringPoolingDataSource.class);
    private final Map<PoolGuardConnectionWrapper, Long> activeConnectionMap = new IdentityHashMap<PoolGuardConnectionWrapper, Long>();
    private final long activeConnectionsLogInterval;
    private final int activeConnectionsLogThreshold;
    private final long oldActiveConnectionTimeMillis;
    private final boolean logStackTrace;
    private long lastLogged;
    private int maxActiveSinceLastLogged;
    private volatile boolean logConnection;

    public MonitoringPoolingDataSource(ObjectPool pool, long activeConnectionsLogInterval, int activeConnectionsLogThreshold, long oldActiveConnectionTimeMillis, boolean logStackTrace) {
        super(pool);
        this.activeConnectionsLogThreshold = activeConnectionsLogThreshold;
        this.activeConnectionsLogInterval = activeConnectionsLogInterval;
        this.oldActiveConnectionTimeMillis = oldActiveConnectionTimeMillis;
        this.logStackTrace = logStackTrace;
    }

    public Connection getConnection() throws SQLException {
        try {
            Object conn = (Connection)this._pool.borrowObject();
            long now = System.currentTimeMillis();
            int numActive = this._pool.getNumActive();
            this.maxActiveSinceLastLogged = Math.max(this.maxActiveSinceLastLogged, numActive);
            if (numActive > this.activeConnectionsLogThreshold) {
                if (!this.logConnection) {
                    this.logConnection = true;
                    if (this.activeConnectionsLogThreshold > 0) {
                        notifyLog.warn(String.format("Switch on database connection logging: %d > %d", numActive, this.activeConnectionsLogThreshold));
                    } else if (machineLog.isInfoEnabled()) {
                        machineLog.info(String.format("Switch on database connection logging: %d > %d", numActive, this.activeConnectionsLogThreshold));
                    }
                }
            } else if (this.logConnection) {
                this.logConnection = false;
                if (machineLog.isInfoEnabled()) {
                    machineLog.info(String.format("Switch off database connection logging: %d <= %d", numActive, this.activeConnectionsLogThreshold));
                }
            }
            if (this.activeConnectionsLogInterval > 0L && now - this.lastLogged > this.activeConnectionsLogInterval && this.maxActiveSinceLastLogged > 1) {
                if (machineLog.isInfoEnabled() && !this.logConnection) {
                    machineLog.info(String.format("Active database connections: current: %d, peak: %d.", numActive, this.maxActiveSinceLastLogged));
                }
                this.lastLogged = now;
                this.maxActiveSinceLastLogged = 0;
                if (this.doLogOldConnections()) {
                    for (Map.Entry<PoolGuardConnectionWrapper, Long> entry : this.activeConnectionMap.entrySet()) {
                        if (now - entry.getValue() <= this.oldActiveConnectionTimeMillis) continue;
                        StackTraceElement[] stackTraceOrNull = entry.getKey().tryGetCreationStackTrace();
                        if (stackTraceOrNull != null) {
                            machineLog.warn("Database connection has not been returned: id=" + entry.getKey().hashCode() + ".\n" + MonitoringPoolingDataSource.traceToString(stackTraceOrNull));
                            continue;
                        }
                        machineLog.warn("Database connection has not been returned: id=" + entry.getKey().hashCode() + ".");
                    }
                }
            }
            if (conn != null) {
                conn = new PoolGuardConnectionWrapper((Connection)conn);
                if (this.doLogOldConnections()) {
                    this.activeConnectionMap.put((PoolGuardConnectionWrapper)((Object)conn), now);
                }
            }
            return conn;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            throw new SQLNestedException("Cannot get a connection, pool error " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot get a connection, general error", (Throwable)e);
        }
    }

    boolean doLogOldConnections() {
        return this.oldActiveConnectionTimeMillis > 0L;
    }

    static StackTraceElement[] getStackTrace() {
        Throwable th = new Throwable();
        th.fillInStackTrace();
        return th.getStackTrace();
    }

    static String tryGetServiceMethodName(StackTraceElement[] stackTrace) {
        String innerMethodName = null;
        String outerMethodName = null;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.getClassName().contains("$Proxy")) {
                if (innerMethodName == null) {
                    innerMethodName = e.getMethodName();
                }
                outerMethodName = e.getMethodName();
            }
            ++n2;
        }
        if (innerMethodName == null) {
            return null;
        }
        if (innerMethodName.equals(outerMethodName)) {
            return outerMethodName;
        }
        return String.valueOf(outerMethodName) + " / " + innerMethodName;
    }

    static String traceToString(StackTraceElement[] trace) {
        StringBuilder builder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement te = stackTraceElementArray[n2];
            builder.append("\tat ");
            builder.append(te.toString());
            builder.append('\n');
            ++n2;
        }
        return builder.toString();
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection {
        private final StackTraceElement[] creationStackTraceOrNull;

        PoolGuardConnectionWrapper(Connection delegate) {
            super(delegate);
            this.creationStackTraceOrNull = MonitoringPoolingDataSource.this.doLogOldConnections() ? MonitoringPoolingDataSource.getStackTrace() : null;
            this.log("Hand out database connection");
        }

        StackTraceElement[] tryGetCreationStackTrace() {
            return this.creationStackTraceOrNull;
        }

        void log(String action) {
            if (MonitoringPoolingDataSource.this.logConnection && machineLog.isDebugEnabled()) {
                int numActive = MonitoringPoolingDataSource.this._pool.getNumActive();
                StackTraceElement[] stackTrace = MonitoringPoolingDataSource.getStackTrace();
                String serviceMethod = MonitoringPoolingDataSource.tryGetServiceMethodName(stackTrace);
                if (serviceMethod == null) {
                    if (MonitoringPoolingDataSource.this.logStackTrace) {
                        machineLog.debug(String.valueOf(action) + ", id=" + this.hashCode() + ", active=" + numActive + ".\n" + MonitoringPoolingDataSource.traceToString(stackTrace));
                    } else {
                        machineLog.debug(String.valueOf(action) + ", id=" + this.hashCode() + ", active=" + numActive + ".");
                    }
                } else if (MonitoringPoolingDataSource.this.logStackTrace) {
                    machineLog.debug(String.valueOf(action) + ", id=" + this.hashCode() + ", active=" + numActive + ", service method: " + serviceMethod + ".\n" + MonitoringPoolingDataSource.traceToString(stackTrace));
                } else {
                    machineLog.debug(String.valueOf(action) + ", id=" + this.hashCode() + ", active=" + numActive + ", service method: " + serviceMethod + ".");
                }
            }
        }

        protected void checkOpen() throws SQLException {
            if (this._conn == null) {
                throw new SQLException("Connection is closed.");
            }
        }

        public void close() throws SQLException {
            if (this._conn != null) {
                this._conn.close();
                super.setDelegate(null);
                if (MonitoringPoolingDataSource.this.doLogOldConnections()) {
                    MonitoringPoolingDataSource.this.activeConnectionMap.remove((Object)this);
                }
                this.log("Return database connection");
            }
        }

        public boolean isClosed() throws SQLException {
            if (this._conn == null) {
                return true;
            }
            return this._conn.isClosed();
        }

        public void clearWarnings() throws SQLException {
            this.checkOpen();
            this._conn.clearWarnings();
        }

        public void commit() throws SQLException {
            this.checkOpen();
            this._conn.commit();
        }

        public Statement createStatement() throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this._conn.createStatement());
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this._conn.createStatement(resultSetType, resultSetConcurrency));
        }

        public boolean innermostDelegateEquals(Connection c) {
            Connection innerCon = super.getInnermostDelegate();
            if (innerCon == null) {
                return c == null;
            }
            return innerCon.equals(c);
        }

        public boolean getAutoCommit() throws SQLException {
            this.checkOpen();
            return this._conn.getAutoCommit();
        }

        public String getCatalog() throws SQLException {
            this.checkOpen();
            return this._conn.getCatalog();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkOpen();
            return this._conn.getMetaData();
        }

        public int getTransactionIsolation() throws SQLException {
            this.checkOpen();
            return this._conn.getTransactionIsolation();
        }

        public Map getTypeMap() throws SQLException {
            this.checkOpen();
            return this._conn.getTypeMap();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.checkOpen();
            return this._conn.getWarnings();
        }

        public boolean isReadOnly() throws SQLException {
            this.checkOpen();
            return this._conn.isReadOnly();
        }

        public String nativeSQL(String sql) throws SQLException {
            this.checkOpen();
            return this._conn.nativeSQL(sql);
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this._conn.prepareCall(sql));
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this._conn.prepareCall(sql, resultSetType, resultSetConcurrency));
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }

        public void rollback() throws SQLException {
            this.checkOpen();
            this._conn.rollback();
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.checkOpen();
            this._conn.setAutoCommit(autoCommit);
        }

        public void setCatalog(String catalog) throws SQLException {
            this.checkOpen();
            this._conn.setCatalog(catalog);
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this.checkOpen();
            this._conn.setReadOnly(readOnly);
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this.checkOpen();
            this._conn.setTransactionIsolation(level);
        }

        public void setTypeMap(Map map) throws SQLException {
            this.checkOpen();
            this._conn.setTypeMap(map);
        }

        public String toString() {
            if (this._conn == null) {
                return "NULL";
            }
            return this._conn.toString();
        }

        public int getHoldability() throws SQLException {
            this.checkOpen();
            return this._conn.getHoldability();
        }

        public void setHoldability(int holdability) throws SQLException {
            this.checkOpen();
            this._conn.setHoldability(holdability);
        }

        public Savepoint setSavepoint() throws SQLException {
            this.checkOpen();
            return this._conn.setSavepoint();
        }

        public Savepoint setSavepoint(String name) throws SQLException {
            this.checkOpen();
            return this._conn.setSavepoint(name);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this._conn.releaseSavepoint(savepoint);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this._conn.rollback(savepoint);
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, autoGeneratedKeys));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, columnIndexes));
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this._conn.prepareStatement(sql, columnNames));
        }

        public Connection getDelegate() {
            if (MonitoringPoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        public Connection getInnermostDelegate() {
            if (MonitoringPoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

