/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.EntityMetaprojectRelationRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaprojectCreator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaprojectRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.PropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.ISampleListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.SampleRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.SampleRelationshipRecord;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.QueryTool;

public class SampleLister
implements ISampleLister {
    private static final Comparator<Sample> SAMPLE_COMPARATOR = new Comparator<Sample>(){

        @Override
        public int compare(Sample s1, Sample s2) {
            return s1.getIdentifier().compareTo(s2.getIdentifier());
        }
    };
    private static final Comparator<SampleRecord> SAMPLE_COMPARATOR2 = new Comparator<SampleRecord>(){

        @Override
        public int compare(SampleRecord s1, SampleRecord s2) {
            return this.getIdentifier(s1).compareTo(this.getIdentifier(s2));
        }

        private String getIdentifier(SampleRecord sampleRecord) {
            String spaceCode = sampleRecord.sp_code;
            String sampleCode = sampleRecord.s_code;
            return spaceCode == null ? "/" + sampleCode : "/" + spaceCode + "/" + sampleCode;
        }
    };
    private static final IKeyExtractor<Long, SampleRecord> ID_EXTRACTOR = new IKeyExtractor<Long, SampleRecord>(){

        @Override
        public Long getKey(SampleRecord s) {
            return s.s_id;
        }
    };
    private final ISampleListingQuery query;
    private Long relationID;
    private PersonPE person;

    public SampleLister(IDAOFactory daoFactory, PersonPE person) {
        this((ISampleListingQuery)QueryTool.getManagedQuery(ISampleListingQuery.class), person);
    }

    SampleLister(ISampleListingQuery query, PersonPE person) {
        this.query = query;
        this.person = person;
    }

    private Long getRelationShipType() {
        if (this.relationID == null) {
            String code = CodeConverter.tryToDatabase("$PARENT_CHILD");
            boolean internalNamespace = CodeConverter.isInternalNamespace("$PARENT_CHILD");
            this.relationID = this.query.getRelationshipTypeId(code, internalNamespace);
        }
        return this.relationID;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Sample> getSamples(Collection<Long> sampleIDs, EnumSet<SampleFetchOption> fetchOptions, IValidator<IIdentifierHolder> filter) {
        void var8_13;
        if (sampleIDs.isEmpty()) {
            return Collections.emptyList();
        }
        LongOpenHashSet sampleIdSet = new LongOpenHashSet(sampleIDs);
        LongOpenHashSet rootSampleIdSet = new LongOpenHashSet(sampleIDs);
        List<Object> descendants = Collections.emptyList();
        if (fetchOptions.contains(SampleFetchOption.DESCENDANTS)) {
            descendants = this.query.getDescendants(this.getRelationShipType(), (LongSet)rootSampleIdSet);
        } else if (fetchOptions.contains(SampleFetchOption.CHILDREN)) {
            descendants = this.query.getChildren(this.getRelationShipType(), (LongSet)rootSampleIdSet);
        }
        LongOpenHashSet descendentIdSet = new LongOpenHashSet();
        for (SampleRelationshipRecord sampleRelationshipRecord : descendants) {
            sampleIdSet.add(sampleRelationshipRecord.sample_id_child);
            descendentIdSet.add(sampleRelationshipRecord.sample_id_child);
        }
        List list = Collections.emptyList();
        if (fetchOptions.contains(SampleFetchOption.ANCESTORS)) {
            List<SampleRelationshipRecord> list2 = this.query.getAncestors(this.getRelationShipType(), (LongSet)rootSampleIdSet);
        } else if (fetchOptions.contains(SampleFetchOption.PARENTS)) {
            List<SampleRelationshipRecord> list3 = this.query.getParents(this.getRelationShipType(), (LongSet)rootSampleIdSet);
        }
        LongOpenHashSet ancestorIdSet = new LongOpenHashSet();
        for (SampleRelationshipRecord sampleRelationshipRecord : var8_13) {
            sampleIdSet.add(sampleRelationshipRecord.sample_id_parent);
            ancestorIdSet.add(sampleRelationshipRecord.sample_id_parent);
        }
        TableMap<Long, SampleRecord> tableMap = this.getAllSamples((LongSet)sampleIdSet, (LongSet)rootSampleIdSet, (LongSet)descendentIdSet, (LongSet)ancestorIdSet, fetchOptions);
        if (fetchOptions.contains(SampleFetchOption.PROPERTIES)) {
            this.enrichWithProperties(tableMap, (LongSet)sampleIdSet);
        }
        this.enrichWithDescendants(descendants, tableMap, fetchOptions.contains(SampleFetchOption.DESCENDANTS));
        this.enrichWithAncestors((List<SampleRelationshipRecord>)var8_13, tableMap, fetchOptions.contains(SampleFetchOption.ANCESTORS));
        ArrayList<Sample> samples = new ArrayList<Sample>();
        if (fetchOptions.contains(SampleFetchOption.METAPROJECTS)) {
            this.enrichWithMetaprojects(tableMap, (LongSet)sampleIdSet);
        }
        HashMap<Long, Sample> repository = new HashMap<Long, Sample>();
        for (Long rootSampleID : sampleIDs) {
            Sample sample;
            SampleRecord sampleRecord = tableMap.tryGet(rootSampleID);
            if (sampleRecord == null || !filter.isValid(this.person, sample = this.createSample(sampleRecord, repository, filter))) continue;
            samples.add(sample);
        }
        for (Sample sample : repository.values()) {
            if (sample.getRetrievedFetchOptions().contains(SampleFetchOption.CHILDREN)) {
                sample.getChildren();
            }
            if (!sample.getRetrievedFetchOptions().contains(SampleFetchOption.PARENTS)) continue;
            sample.getParents();
        }
        repository.clear();
        Collections.sort(samples, SAMPLE_COMPARATOR);
        return samples;
    }

    private TableMap<Long, SampleRecord> getAllSamples(LongSet sampleIdSet, LongSet rootSampleIdSet, LongSet descendentIdSet, LongSet ancestorIdSet, EnumSet<SampleFetchOption> fetchOptions) {
        List<SampleRecord> list = this.query.listSamplesByIds(sampleIdSet);
        TableMap<Long, SampleRecord> sampleRecords = new TableMap<Long, SampleRecord>(list, ID_EXTRACTOR);
        for (SampleRecord sampleRecord : sampleRecords) {
            sampleRecord.fetchOptions = this.createAppropriateFetchOptions(fetchOptions);
            if (rootSampleIdSet.contains((Object)sampleRecord.s_id)) {
                if (fetchOptions.contains(SampleFetchOption.CHILDREN) || fetchOptions.contains(SampleFetchOption.DESCENDANTS)) {
                    sampleRecord.fetchOptions.add(SampleFetchOption.CHILDREN);
                }
                if (!fetchOptions.contains(SampleFetchOption.PARENTS) && !fetchOptions.contains(SampleFetchOption.ANCESTORS)) continue;
                sampleRecord.fetchOptions.add(SampleFetchOption.PARENTS);
                continue;
            }
            if (fetchOptions.contains(SampleFetchOption.ANCESTORS) && ancestorIdSet.contains((Object)sampleRecord.s_id)) {
                sampleRecord.fetchOptions.add(SampleFetchOption.PARENTS);
                continue;
            }
            if (!fetchOptions.contains(SampleFetchOption.DESCENDANTS) || !descendentIdSet.contains((Object)sampleRecord.s_id)) continue;
            sampleRecord.fetchOptions.add(SampleFetchOption.CHILDREN);
        }
        return sampleRecords;
    }

    private void enrichWithAncestors(List<SampleRelationshipRecord> ancestors, TableMap<Long, SampleRecord> sampleRecords, boolean allAncestors) {
        for (SampleRelationshipRecord ancestor : ancestors) {
            SampleRecord parent = sampleRecords.tryGet(ancestor.sample_id_parent);
            SampleRecord child = sampleRecords.tryGet(ancestor.sample_id_child);
            if (parent == null || child == null) continue;
            if (child.parents == null) {
                child.parents = new LinkedList<SampleRecord>();
                if (allAncestors) {
                    child.fetchOptions.add(SampleFetchOption.PARENTS);
                }
            }
            child.parents.add(parent);
        }
    }

    private void enrichWithDescendants(List<SampleRelationshipRecord> descendants, TableMap<Long, SampleRecord> sampleRecords, boolean allDescendants) {
        for (SampleRelationshipRecord descendant : descendants) {
            SampleRecord parent = sampleRecords.tryGet(descendant.sample_id_parent);
            SampleRecord child = sampleRecords.tryGet(descendant.sample_id_child);
            if (parent == null || child == null) continue;
            if (parent.children == null) {
                parent.children = new LinkedList<SampleRecord>();
                if (allDescendants) {
                    parent.fetchOptions.add(SampleFetchOption.CHILDREN);
                }
            }
            parent.children.add(child);
        }
    }

    private void enrichWithProperties(TableMap<Long, SampleRecord> sampleRecords, LongSet sampleIdSet) {
        List<PropertyRecord> properties = this.query.getProperties(sampleIdSet);
        for (PropertyRecord propertyRecord : properties) {
            SampleRecord sampleRecord = sampleRecords.tryGet(propertyRecord.entity_id);
            if (sampleRecord == null) continue;
            if (sampleRecord.properties == null) {
                sampleRecord.properties = new HashMap<String, String>();
            }
            sampleRecord.properties.put(propertyRecord.code, propertyRecord.getValue());
        }
    }

    private void enrichWithMetaprojects(TableMap<Long, SampleRecord> sampleRecords, LongSet sampleIdSet) {
        List<EntityMetaprojectRelationRecord> sampleMetaprojectRelations = this.query.getMetaprojectAssignments(sampleIdSet, this.person.getId());
        LongOpenHashSet metaprojectIdSet = new LongOpenHashSet();
        for (EntityMetaprojectRelationRecord record : sampleMetaprojectRelations) {
            metaprojectIdSet.add((Object)record.metaproject_id);
        }
        List<MetaprojectRecord> metaprojects = this.query.getMetaprojects((LongSet)metaprojectIdSet);
        TableMap<Long, MetaprojectRecord> metaprojectRecords = new TableMap<Long, MetaprojectRecord>(metaprojects, new IKeyExtractor<Long, MetaprojectRecord>(){

            @Override
            public Long getKey(MetaprojectRecord mr) {
                return mr.id;
            }
        });
        for (EntityMetaprojectRelationRecord record : sampleMetaprojectRelations) {
            MetaprojectRecord metaprojectRecord;
            SampleRecord sampleRecord = sampleRecords.tryGet(record.entity_id);
            if (sampleRecord == null) continue;
            if (sampleRecord.metaprojects == null) {
                sampleRecord.metaprojects = new ArrayList<MetaprojectRecord>();
            }
            if ((metaprojectRecord = metaprojectRecords.tryGet(record.metaproject_id)) == null) continue;
            sampleRecord.metaprojects.add(metaprojectRecord);
        }
    }

    private Sample createSample(SampleRecord sampleRecord, Map<Long, Sample> repository, IValidator<IIdentifierHolder> filter) {
        Map<String, String> properties;
        Sample sample = repository.get(sampleRecord.s_id);
        if (sample != null) {
            return sample;
        }
        Sample.SampleInitializer initializer = new Sample.SampleInitializer();
        initializer.setId(sampleRecord.s_id);
        initializer.setStub(false);
        String spaceCode = sampleRecord.sp_code;
        initializer.setSpaceCode(spaceCode);
        String sampleCode = sampleRecord.s_code;
        String containerCode = sampleRecord.container_code;
        if (containerCode != null) {
            sampleCode = String.valueOf(containerCode) + ":" + sampleCode;
        }
        initializer.setCode(sampleCode);
        initializer.setIdentifier(spaceCode == null ? "/" + sampleCode : "/" + spaceCode + "/" + sampleCode);
        initializer.setPermId(sampleRecord.s_perm_id);
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer detailsInitializer = new EntityRegistrationDetails.EntityRegistrationDetailsInitializer();
        detailsInitializer.setRegistrationDate(sampleRecord.s_registration_timestamp);
        detailsInitializer.setModificationDate(sampleRecord.s_modification_timestamp);
        detailsInitializer.setUserId(sampleRecord.pe_user_id);
        detailsInitializer.setEmail(sampleRecord.pe_email);
        detailsInitializer.setFirstName(sampleRecord.pe_first_name);
        detailsInitializer.setLastName(sampleRecord.pe_last_name);
        detailsInitializer.setModifierUserId(sampleRecord.mod_user_id);
        detailsInitializer.setModifierEmail(sampleRecord.mod_email);
        detailsInitializer.setModifierFirstName(sampleRecord.mod_first_name);
        detailsInitializer.setModifierLastName(sampleRecord.mod_last_name);
        initializer.setRegistrationDetails(new EntityRegistrationDetails(detailsInitializer));
        initializer.setSampleTypeId(sampleRecord.st_id);
        initializer.setSampleTypeCode(sampleRecord.st_code);
        if (sampleRecord.exp_code != null) {
            initializer.setExperimentIdentifierOrNull("/" + sampleRecord.proj_space_code + "/" + sampleRecord.proj_code + "/" + sampleRecord.exp_code);
        }
        if ((properties = sampleRecord.properties) != null) {
            for (Map.Entry entry : properties.entrySet()) {
                initializer.putProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (sampleRecord.metaprojects != null) {
            for (MetaprojectRecord metaprojectRecord : sampleRecord.metaprojects) {
                initializer.addMetaproject(MetaprojectCreator.createMetaproject(metaprojectRecord, this.person));
            }
        }
        initializer.setRetrievedFetchOptions(sampleRecord.fetchOptions);
        ArrayList<SampleRecord> arrayList = new ArrayList<SampleRecord>();
        if (sampleRecord.children != null) {
            initializer.setChildReferences(this.getIDs(sampleRecord.children), repository);
            arrayList.addAll(sampleRecord.children);
        }
        if (sampleRecord.parents != null) {
            initializer.setParentReferences(this.getIDs(sampleRecord.parents), repository);
            arrayList.addAll(sampleRecord.parents);
        }
        if (filter.isValid(this.person, sample = new Sample(initializer))) {
            repository.put(sampleRecord.s_id, sample);
        }
        for (SampleRecord linkedSampleRecord : arrayList) {
            this.createSample(linkedSampleRecord, repository, filter);
        }
        return sample;
    }

    private List<Long> getIDs(List<SampleRecord> records) {
        Collections.sort(records, SAMPLE_COMPARATOR2);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SampleRecord record : records) {
            ids.add(record.s_id);
        }
        return ids;
    }

    private EnumSet<SampleFetchOption> createAppropriateFetchOptions(EnumSet<SampleFetchOption> fetchOptions) {
        EnumSet<SampleFetchOption> result = EnumSet.of(fetchOptions.contains(SampleFetchOption.PROPERTIES) ? SampleFetchOption.PROPERTIES : SampleFetchOption.BASIC);
        if (fetchOptions.contains(SampleFetchOption.METAPROJECTS)) {
            result.add(SampleFetchOption.METAPROJECTS);
        }
        return result;
    }
}

