/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleBrowserGrid;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.EntityConnectionTypeProvider;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.CheckBox;

public class ExperimentSamplesSection
extends DisposableTabContent {
    private static final String PREFIX = "experiment-samples-section_";
    public static final String ID_PREFIX = "openbis_experiment-samples-section_";
    private final BasicEntityType experimentType;
    private final TechId experimentId;
    private final CheckBox showOnlyDirectlyConnectedCheckBox;

    public ExperimentSamplesSection(IViewContext<?> viewContext, String header, BasicEntityType experimentType, IIdAndCodeHolder experimentId) {
        super(header, viewContext, experimentId);
        this.experimentType = experimentType;
        this.experimentId = new TechId(experimentId.getId());
        this.setIds(DisplayTypeIDGenerator.EXPERIMENT_SAMPLES_SECTION);
        this.showOnlyDirectlyConnectedCheckBox = this.createShowOnlyDirectlyConnectedCheckBox();
    }

    private CheckBox createShowOnlyDirectlyConnectedCheckBox() {
        CheckBox result = new CheckBox();
        result.setId(String.valueOf(this.getId()) + "-show_only_directly_connected_checkbox");
        result.setBoxLabel(this.viewContext.getMessage("show_only_directly_connected", new Object[0]));
        result.setValue(Boolean.valueOf(true));
        return result;
    }

    static String createGridId(TechId experimentId) {
        return SampleBrowserGrid.createGridId(ExperimentSamplesSection.createBrowserId(experimentId));
    }

    private static String createBrowserId(TechId experimentId) {
        return ID_PREFIX + experimentId + "-browser";
    }

    @Override
    protected IDisposableComponent createDisposableContent() {
        IDisposableComponent disposableComponent = SampleBrowserGrid.createGridForExperimentSamples(this.viewContext.getCommonViewContext(), this.experimentId, ExperimentSamplesSection.createBrowserId(this.experimentId), this.experimentType, new EntityConnectionTypeProvider(this.showOnlyDirectlyConnectedCheckBox));
        this.getHeader().addTool((Component)this.showOnlyDirectlyConnectedCheckBox);
        return disposableComponent;
    }
}

