/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.deserializer;

import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import java.io.IOException;

public class JsonTypeAndClassSerializer
extends AsPropertyTypeSerializer {
    public JsonTypeAndClassSerializer(TypeIdResolver idRes, BeanProperty property, String propName) {
        super(idRes, property, propName);
    }

    public JsonTypeAndClassSerializer forProperty(BeanProperty prop) {
        if (this._property == prop) {
            return this;
        }
        return new JsonTypeAndClassSerializer(this._idResolver, prop, this._typePropertyName);
    }

    public void writeTypePrefixForObject(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        if (this.isValueWithType(value)) {
            jgen.writeStartObject();
            jgen.writeStringField(this._typePropertyName, this.idFromValue(value));
        } else {
            jgen.writeStartObject();
        }
    }

    public void writeTypeSuffixForObject(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeEndObject();
    }

    public void writeTypePrefixForScalar(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        if (this.isValueWithType(value)) {
            super.writeTypePrefixForScalar(value, jgen);
        }
    }

    public void writeTypeSuffixForScalar(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        if (this.isValueWithType(value)) {
            super.writeTypeSuffixForScalar(value, jgen);
        }
    }

    public void writeTypePrefixForArray(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeStartArray();
    }

    public void writeTypeSuffixForArray(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeEndArray();
    }

    private boolean isValueWithType(Object value) {
        return value != null && value.getClass().isAnnotationPresent(JsonObject.class) && !value.getClass().isEnum();
    }
}

