/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.ldap;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.ldap.LDAPDirectoryConfiguration;
import ch.systemsx.cisd.authentication.ldap.LDAPPrincipalQuery;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.List;
import org.apache.log4j.Logger;

public class LDAPAuthenticationService
implements IAuthenticationService {
    private static final String DUMMY_TOKEN_STR = "DUMMY-TOKEN";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, LDAPAuthenticationService.class);
    private final LDAPPrincipalQuery query;
    private final boolean configured;

    public LDAPAuthenticationService(LDAPDirectoryConfiguration config) {
        this.query = new LDAPPrincipalQuery(config);
        this.configured = config.isConfigured();
    }

    @Override
    public String authenticateApplication() {
        return DUMMY_TOKEN_STR;
    }

    @Override
    public boolean authenticateUser(String applicationToken, String user, String password) {
        return this.authenticateUser(user, password);
    }

    @Override
    public boolean authenticateUser(String user, String password) {
        boolean authenticated = this.query.authenticateUser(user, password);
        this.logAuthentication(user, authenticated);
        return authenticated;
    }

    private void logAuthentication(String user, boolean authenticated) {
        if (operationLog.isInfoEnabled()) {
            String msg = "LDAP: authentication of user '" + user + "': ";
            operationLog.info((Object)(String.valueOf(msg) + (authenticated ? "SUCCESS." : "FAILED.")));
        }
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String applicationToken, String user, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(user, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String user, String passwordOrNull) {
        Principal principal = this.query.tryGetAndAuthenticatePrincipal(user, passwordOrNull);
        this.logAuthentication(user, Principal.isAuthenticated(principal));
        return principal;
    }

    @Override
    public Principal getPrincipal(String applicationToken, String user) throws IllegalArgumentException {
        return this.getPrincipal(user);
    }

    @Override
    public Principal getPrincipal(String user) throws IllegalArgumentException {
        Principal principalOrNull = this.query.tryGetPrincipal(user);
        if (principalOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + user + "'.");
        }
        return principalOrNull;
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String applicationToken, String emailQuery) {
        return this.listPrincipalsByEmail(emailQuery);
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String emailQuery) {
        return this.query.listPrincipalsByEmail(emailQuery);
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String applicationToken, String email, String passwordOrNull) {
        return this.tryGetAndAuthenticateUserByEmail(email, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String email, String passwordOrNull) {
        Principal principal = this.query.tryGetAndAuthenticatePrincipalByEmail(email, passwordOrNull);
        String user = principal != null ? principal.getUserId() : "email:" + email;
        this.logAuthentication(user, Principal.isAuthenticated(principal));
        return principal;
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String applicationToken, String lastNameQuery) {
        return this.listPrincipalsByLastName(lastNameQuery);
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String lastNameQuery) {
        return this.query.listPrincipalsByLastName(lastNameQuery);
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String applicationToken, String userIdQuery) {
        return this.listPrincipalsByUserId(userIdQuery);
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String userIdQuery) {
        return this.query.listPrincipalsByUserId(userIdQuery);
    }

    @Override
    public boolean supportsListingByEmail() {
        return true;
    }

    @Override
    public boolean supportsListingByLastName() {
        return true;
    }

    @Override
    public boolean supportsListingByUserId() {
        return true;
    }

    @Override
    public boolean supportsAuthenticatingByEmail() {
        return true;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        this.query.check();
    }

    @Override
    public boolean isRemote() {
        return this.query.isRemote();
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }
}

