/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.entityregistration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.etlserver.entityregistration.AbstractSampleAndDataSetProcessor;
import ch.systemsx.cisd.etlserver.entityregistration.SampleAndDataSetControlFileProcessor;
import ch.systemsx.cisd.etlserver.entityregistration.SampleAndDataSetRegistrationGlobalState;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.filefilter.RegexFileFilter;

class SampleAndDataSetFolderProcessor
extends AbstractSampleAndDataSetProcessor {
    static final String ERRORS_FILENAME = "errors.txt";
    private final ArrayList<File> controlFiles = new ArrayList();
    private final HashMap<File, Exception> errorMap = new HashMap();

    SampleAndDataSetFolderProcessor(SampleAndDataSetRegistrationGlobalState globalState, File folder) {
        super(globalState, folder);
    }

    public void register() throws UserFailureException, EnvironmentFailureException {
        try {
            this.checkFolderIsFolder();
            this.collectControlFilesOrThrowError();
            for (File controlFile : this.controlFiles) {
                try {
                    SampleAndDataSetControlFileProcessor controlFileProcessor = new SampleAndDataSetControlFileProcessor(this.globalState, this.folder, controlFile);
                    controlFileProcessor.register();
                }
                catch (UserFailureException e) {
                    e.printStackTrace();
                    this.errorMap.put(controlFile, e);
                }
            }
            this.checkErrorMapIsEmpty();
        }
        catch (UserFailureException e) {
            this.sendEmailWithErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            this.sendEmailWithErrorMessage(e.getMessage());
            throw new CheckedExceptionTunnel(e);
        }
    }

    private void checkFolderIsFolder() throws UserFailureException {
        if (!this.folder.isDirectory()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.folder.getName());
            sb.append(" is an ordinary file. It must be a folder containing a control file and data subfolders.");
            throw new UserFailureException(sb.toString());
        }
    }

    private FileFilter getFileFilter() {
        return new RegexFileFilter(this.getControlFilePattern());
    }

    private String getControlFilePattern() {
        return this.globalState.getControlFilePattern();
    }

    private void collectControlFilesOrThrowError() throws UserFailureException {
        File[] files = this.folder.listFiles(this.getFileFilter());
        Collections.addAll(this.controlFiles, files);
        if (this.controlFiles.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Folder (");
            sb.append(this.folder.getName());
            sb.append(") for sample/dataset registration contains no control files matching the configured pattern: ");
            sb.append(this.getControlFilePattern());
            sb.append(".");
            sb.append("\nFolder contents:");
            String[] stringArray = this.folder.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                sb.append("\n\t");
                sb.append(filename);
                ++n2;
            }
            sb.append("\n");
            throw new UserFailureException(sb.toString());
        }
    }

    private void checkErrorMapIsEmpty() {
        if (this.errorMap.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (File file : this.errorMap.keySet()) {
            sb.append("Encountered error processing ");
            sb.append(file.getName());
            sb.append(" :\n\t");
            sb.append(this.errorMap.get(file));
            sb.append("\n");
        }
        throw new UserFailureException(sb.toString());
    }

    protected void sendEmailWithErrorMessage(String message) {
        this.logError(message);
        try {
            String subject = this.createErrorEmailSubject();
            String content = this.createErrorEmailContent();
            String filename = ERRORS_FILENAME;
            EMailAddress[] recipients = this.globalState.getErrorEmailRecipients();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(message, "text/plain");
            this.globalState.getMailClient().sendEmailMessageWithAttachment(subject, content, filename, new DataHandler((DataSource)dataSource), null, null, recipients);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private String createErrorEmailSubject() {
        return String.format("Sample / Data Set Registration Error -- %s", this.folder);
    }

    private String createErrorEmailContent() {
        return String.format("When trying to process the files in the folder, %s, errors were encountered. These errors are detailed in the attachment.", this.folder);
    }
}

