/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.etlserver.plugins.AbstractDataSetDeletionPostProcessingMaintenanceTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringEscapeUtils;

public class DeleteFromExternalDBMaintenanceTask
extends AbstractDataSetDeletionPostProcessingMaintenanceTask {
    private static final String DEFAULT_DATA_SET_PERM_ID = "PERM_ID";
    private static final String DATA_SET_PERM_ID_KEY = "data-set-perm-id";
    private static final String DATA_SET_TABLE_NAME_KEY = "data-set-table-name";
    private static final String DEFAULT_DATA_SET_TABLE_NAME = "image_data_sets, analysis_data_sets";
    private static final String LAST_SEEN_EVENT_ID_COLUMN_KEY = "last-seen-event-id-column";
    private static final String SYNCHRONIZATION_TABLE_KEY = "synchronization-table";
    private static final String DEFAULT_SYNCHRONIZATION_TABLE = "EVENTS";
    private static final String DEFAULT_LAST_SEEN_EVENT_ID = "LAST_SEEN_DELETION_EVENT_ID";
    private DataSource dataSource;
    private String synchronizationTable;
    private String lastSeenEventID;
    protected String[] dataSetTableNames;
    protected String permIDColumn;
    protected Connection connection;

    @Override
    public void setUp(String pluginName, Properties properties) {
        super.setUp(pluginName, properties);
        this.synchronizationTable = properties.getProperty(SYNCHRONIZATION_TABLE_KEY, DEFAULT_SYNCHRONIZATION_TABLE);
        this.lastSeenEventID = properties.getProperty(LAST_SEEN_EVENT_ID_COLUMN_KEY, DEFAULT_LAST_SEEN_EVENT_ID);
        this.dataSetTableNames = properties.getProperty(DATA_SET_TABLE_NAME_KEY, DEFAULT_DATA_SET_TABLE_NAME).split(",");
        this.permIDColumn = properties.getProperty(DATA_SET_PERM_ID_KEY, DEFAULT_DATA_SET_PERM_ID);
        this.dataSource = ServiceProvider.getDataSourceProvider().getDataSource(properties);
        this.checkDatabaseConnection();
    }

    @Override
    public void execute() {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)"Synchronizing data set information");
        }
        this.connection = null;
        try {
            try {
                this.connection = this.createConnection();
                super.execute();
            }
            catch (Exception e) {
                operationLog.error((Object)e);
                this.closeConnection(this.connection);
            }
        }
        finally {
            this.closeConnection(this.connection);
        }
    }

    @Override
    protected Long getLastSeenEventId() {
        try {
            return this.tryGetPreviousLastSeenEventId(this.connection);
        }
        catch (SQLException sqlEx) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)sqlEx);
        }
    }

    @Override
    protected void updateLastSeenEventId(Long newLastSeenEventId) {
        try {
            this.executeSql("delete from " + this.synchronizationTable);
            this.executeSql("INSERT INTO " + this.synchronizationTable + " (" + this.lastSeenEventID + ") VALUES('" + newLastSeenEventId + "')");
        }
        catch (SQLException sqlEx) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)sqlEx);
        }
    }

    @Override
    protected void execute(List<DeletedDataSet> datasets) {
        try {
            boolean autoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            long t0 = System.currentTimeMillis();
            this.deleteDatasets(datasets);
            this.connection.commit();
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Synchronization task took " + (System.currentTimeMillis() - t0 + 500L) / 1000L + " seconds."));
            }
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlEx) {
            operationLog.error((Object)sqlEx);
        }
    }

    private void checkDatabaseConnection() {
        Connection c = null;
        try {
            try {
                c = this.createConnection();
                this.tryGetPreviousLastSeenEventId(c);
            }
            catch (SQLException sqlEx) {
                throw new ConfigurationFailureException("Initialization failed", sqlEx);
            }
        }
        finally {
            this.closeConnection(c);
        }
    }

    private void closeConnection(Connection connectionOrNull) {
        if (connectionOrNull != null) {
            try {
                connectionOrNull.close();
            }
            catch (SQLException ex) {
                operationLog.error((Object)ex);
            }
        }
    }

    private Connection createConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected void deleteDatasets(List<DeletedDataSet> deletedDataSets) throws SQLException {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Synchronizing deletions of %d datasets with the database.", deletedDataSets.size()));
        }
        String[] stringArray = this.dataSetTableNames;
        int n = this.dataSetTableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String dataSetTableName = stringArray[n2];
            this.connection.createStatement().execute(String.format("DELETE FROM " + dataSetTableName.trim() + " WHERE " + this.permIDColumn + " IN (%s)", DeleteFromExternalDBMaintenanceTask.joinIds(deletedDataSets)));
            ++n2;
        }
    }

    private void executeSql(String sql) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        statement.executeUpdate();
    }

    protected static String joinIds(List<DeletedDataSet> deletedDatasetCodes) {
        StringBuilder sb = new StringBuilder();
        for (DeletedDataSet dds : deletedDatasetCodes) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("'" + StringEscapeUtils.escapeSql((String)dds.getIdentifier()) + "'");
        }
        String ids = sb.toString();
        return ids;
    }

    private Long tryGetPreviousLastSeenEventId(Connection c) throws SQLException {
        Long maxLastSeenEventId = null;
        ResultSet result = c.createStatement().executeQuery("SELECT MAX(" + this.lastSeenEventID + ") AS " + this.lastSeenEventID + " FROM " + this.synchronizationTable);
        while (result.next()) {
            long newLastSeenEventId = result.getLong(this.lastSeenEventID);
            if (maxLastSeenEventId != null && maxLastSeenEventId >= newLastSeenEventId) continue;
            maxLastSeenEventId = newLastSeenEventId;
        }
        return maxLastSeenEventId;
    }
}

