/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.NullStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStoragePrecommitRecoveryAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageRecoveryAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageStoredRecoveryAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import java.io.File;

public abstract class AbstractNoFileDataSetStorageAlgorithm<T extends DataSetInformation>
extends DataSetStorageAlgorithm<T> {
    public AbstractNoFileDataSetStorageAlgorithm(File incomingDataSetFile, DataSetRegistrationDetails<? extends T> registrationDetails, IDataStoreStrategy dataStoreStrategy, IStorageProcessorTransactional storageProcessor, IDataSetValidator dataSetValidator, String dataStoreCode, IFileOperations fileOperations, IMailClient mailClient, File stagingDirectory, File precommitDirectory) {
        super(incomingDataSetFile, registrationDetails, dataStoreStrategy, storageProcessor, dataSetValidator, dataStoreCode, fileOperations, mailClient, stagingDirectory, precommitDirectory);
    }

    public AbstractNoFileDataSetStorageAlgorithm(IDataStoreStrategy dataStoreStrategy, IStorageProcessorTransactional storageProcessor, IFileOperations fileOperations, IMailClient mailClient, DataSetStorageRecoveryAlgorithm<T> recoveryAlgorithm) {
        super(dataStoreStrategy, storageProcessor, fileOperations, mailClient, recoveryAlgorithm);
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction prepare(IRollbackStack rollbackStack) {
        return new NullStorageProcessorTransaction();
    }

    @Override
    public void preCommit() throws Throwable {
    }

    @Override
    public void moveToTheStore() throws Throwable {
    }

    @Override
    public void transitionToRolledbackState(Throwable throwable) {
    }

    @Override
    public void transitionToUndoneState() {
    }

    @Override
    public void commitStorageProcessor() {
    }

    @Override
    public void cleanPrecommitDirectory() {
    }

    @Override
    public String getSuccessRegistrationMessage() {
        return super.getSuccessRegistrationMessage();
    }

    @Override
    public String getFailureRegistrationMessage() {
        return "Error trying to register no-file-contents data set '" + ((DataSetInformation)this.getDataSetInformation()).toString() + "'.";
    }

    @Override
    public DataSetStoragePrecommitRecoveryAlgorithm<T> getPrecommitRecoveryAlgorithm() {
        return new DataSetStoragePrecommitRecoveryAlgorithm(this.getDataSetInformation(), this.getDataStoreStrategy().getKey(), this.getIncomingDataSetFile(), this.getStagingDirectory(), this.getPreCommitDirectory(), this.getDataStoreCode(), this.getDataSetKind());
    }

    @Override
    public DataSetStorageStoredRecoveryAlgorithm<T> getStoredRecoveryAlgorithm() {
        return new DataSetStorageStoredRecoveryAlgorithm(this.getDataSetInformation(), this.getDataStoreStrategy().getKey(), this.getIncomingDataSetFile(), this.getStagingDirectory(), this.getPreCommitDirectory(), this.getDataStoreCode(), this.getDataSetKind());
    }

    @Override
    public abstract DataSetKind getDataSetKind();
}

