/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class DatasetAuthorizationCache {
    private final Map<KeyRecord, ValueRecord> cache = new ConcurrentHashMap<KeyRecord, ValueRecord>();
    private Timer expirationTimer = new Timer(true);
    private final long cacheExpirationTimeMillis;

    public DatasetAuthorizationCache(long cacheExpirationTimeMillis, long timerPeriodMillis) {
        this.cacheExpirationTimeMillis = cacheExpirationTimeMillis;
        this.expirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DatasetAuthorizationCache.this.runExpiration();
            }
        }, 0L, timerPeriodMillis);
    }

    private boolean isExpired(ValueRecord v, long now) {
        return now - v.getTimestamp() > this.cacheExpirationTimeMillis;
    }

    private void runExpiration() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<KeyRecord, ValueRecord>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<KeyRecord, ValueRecord> e = it.next();
            if (!this.isExpired(e.getValue(), now)) continue;
            it.remove();
        }
    }

    private ValueRecord tryGet(KeyRecord k) {
        ValueRecord v = this.cache.get(k);
        if (v != null && this.isExpired(v, System.currentTimeMillis())) {
            this.cache.remove(k);
            return null;
        }
        return v;
    }

    public void put(String sessionToken, String datasetCode, boolean authorized) {
        this.cache.put(new KeyRecord(sessionToken, datasetCode), new ValueRecord(authorized));
    }

    public void putAll(String sessionToken, List<String> datasetCodes, boolean authorized) {
        ValueRecord value = new ValueRecord(authorized);
        for (String datasetCode : datasetCodes) {
            this.cache.put(new KeyRecord(sessionToken, datasetCode), value);
        }
    }

    public Boolean tryGet(String sessionToken, String datasetCode) {
        ValueRecord v = this.tryGet(new KeyRecord(sessionToken, datasetCode));
        return v != null ? Boolean.valueOf(v.isAuthorized()) : null;
    }

    public void clear() {
        this.cache.clear();
    }

    private static final class KeyRecord {
        private final String sessionToken;
        private final String datasetCode;

        KeyRecord(String sessionToken, String datasetCode) {
            this.sessionToken = sessionToken;
            this.datasetCode = datasetCode;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.datasetCode == null ? 0 : this.datasetCode.hashCode());
            result = 31 * result + (this.sessionToken == null ? 0 : this.sessionToken.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyRecord other = (KeyRecord)obj;
            if (this.datasetCode == null ? other.datasetCode != null : !this.datasetCode.equals(other.datasetCode)) {
                return false;
            }
            return !(this.sessionToken == null ? other.sessionToken != null : !this.sessionToken.equals(other.sessionToken));
        }
    }

    private static final class ValueRecord {
        private final boolean authorized;
        private final long timestamp;

        ValueRecord(boolean authorized) {
            this.authorized = authorized;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isAuthorized() {
            return this.authorized;
        }

        long getTimestamp() {
            return this.timestamp;
        }
    }
}

