/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.IDatasetImageOverviewPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.Constants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DatasetImageOverviewConfiguration {
    private static final String PLUGIN_SERVICE_CLASS_KEY = "class";
    private static final String PLUGIN_SERVICE_DEFAULT_KEY = "default";
    private static final String PLUGIN_SERVICE_DATASET_TYPE_PATTERNS_KEY = "dataset-types";
    private Map<String, IDatasetImageOverviewPlugin> pluginsByDataSetTypePattern = new HashMap<String, IDatasetImageOverviewPlugin>();
    private IDatasetImageOverviewPlugin defaultPluginOrNull;

    public static DatasetImageOverviewConfiguration createConfiguration(Properties properties) {
        PropertyParametersUtil.SectionProperties[] pluginServicesProperties;
        DatasetImageOverviewConfiguration configuration = new DatasetImageOverviewConfiguration();
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = pluginServicesProperties = PropertyParametersUtil.extractSectionProperties(properties, Constants.OVERVIEW_PLUGINS_SERVICES_LIST_KEY, false);
        int n = pluginServicesProperties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperties = sectionPropertiesArray[n2];
            Properties props = sectionProperties.getProperties();
            String pluginClassName = PropertyUtils.getMandatoryProperty(props, PLUGIN_SERVICE_CLASS_KEY);
            boolean isDefault = PropertyUtils.getBoolean(props, PLUGIN_SERVICE_DEFAULT_KEY, false);
            if (isDefault) {
                configuration.setDefaultPluginService(pluginClassName, props);
            } else {
                List<String> dataSetTypePatterns = PropertyUtils.getMandatoryList(props, PLUGIN_SERVICE_DATASET_TYPE_PATTERNS_KEY);
                configuration.addPluginService(pluginClassName, dataSetTypePatterns, props);
            }
            ++n2;
        }
        return configuration;
    }

    public IDatasetImageOverviewPlugin getDatasetImageOverviewPlugin(String datasetTypeCode) {
        IDatasetImageOverviewPlugin plugin = this.tryFindPlugin(datasetTypeCode);
        if (plugin == null) {
            if (this.defaultPluginOrNull == null) {
                throw new ConfigurationFailureException(String.format("No image overview plugin is configured for data set type %s and there is no default plugin configured either.", datasetTypeCode));
            }
            plugin = this.defaultPluginOrNull;
        }
        return plugin;
    }

    private IDatasetImageOverviewPlugin tryFindPlugin(String datasetTypeCode) {
        for (Map.Entry<String, IDatasetImageOverviewPlugin> entry : this.pluginsByDataSetTypePattern.entrySet()) {
            String datasetTypePattern = entry.getKey();
            if (!datasetTypeCode.matches(datasetTypePattern)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void addPluginService(String pluginClass, List<String> dataSetTypePatterns, Properties pluginProperties) {
        for (String dataSetTypePattern : dataSetTypePatterns) {
            this.addPluginService(dataSetTypePattern, pluginClass, pluginProperties);
        }
    }

    private void addPluginService(String dataSetTypePattern, String pluginClassName, Properties pluginProperties) {
        String normalizedTypePattern = dataSetTypePattern.toUpperCase();
        IDatasetImageOverviewPlugin oldPluginOrNull = this.tryFindPlugin(normalizedTypePattern);
        if (oldPluginOrNull != null) {
            throw new ConfigurationFailureException(String.format("More than one image overview plugin is configured for data set type %s (plugin classes: %s, %s)", oldPluginOrNull.getClass().getName(), pluginClassName));
        }
        IDatasetImageOverviewPlugin plugin = this.createPlugin(pluginClassName, pluginProperties);
        this.pluginsByDataSetTypePattern.put(normalizedTypePattern, plugin);
    }

    private void setDefaultPluginService(String pluginClassName, Properties pluginProperties) {
        IDatasetImageOverviewPlugin plugin;
        if (this.defaultPluginOrNull != null) {
            throw new ConfigurationFailureException(String.format("Default image overview plugin is configured more than once (plugin classes: %s, %s)", this.defaultPluginOrNull.getClass().getName(), pluginClassName));
        }
        this.defaultPluginOrNull = plugin = this.createPlugin(pluginClassName, pluginProperties);
    }

    private IDatasetImageOverviewPlugin createPlugin(String pluginClassName, Properties pluginProperties) {
        try {
            return ClassUtils.create(IDatasetImageOverviewPlugin.class, pluginClassName, pluginProperties);
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot find the plugin class '" + pluginClassName + "'", CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
    }
}

