/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.action.IMapper;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.AuthorizationHelper;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedBasicOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ManagedAuthentication;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public class EncapsulatedFilteredBasicOpenBISService
implements IEncapsulatedBasicOpenBISService {
    private final IServiceForDataStoreServer etlService;
    private final String systemSessionToken;
    private final IEncapsulatedOpenBISService encapsulatedService;
    private final String userName;
    private static final IMapper<AbstractExternalData, String> externalDataCodeMapper = new IMapper<AbstractExternalData, String>(){

        @Override
        public String map(AbstractExternalData item) {
            return item.getCode();
        }
    };
    private static final IMapper<Sample, String> sampleIdMapper = new IMapper<Sample, String>(){

        @Override
        public String map(Sample item) {
            return item.getIdentifier();
        }
    };
    private static final IMapper<Experiment, String> experimentIdMapper = new IMapper<Experiment, String>(){

        @Override
        public String map(Experiment item) {
            return item.getIdentifier();
        }
    };

    public EncapsulatedFilteredBasicOpenBISService(String userName, IServiceForDataStoreServer etlService, IEncapsulatedOpenBISService encapsulatedService, String systemSessionToken) {
        this.etlService = etlService;
        this.encapsulatedService = encapsulatedService;
        this.systemSessionToken = systemSessionToken;
        this.userName = userName;
    }

    @Override
    public Project tryGetProject(ProjectIdentifier projectIdentifier) throws UserFailureException {
        return this.encapsulatedService.tryGetProject(projectIdentifier);
    }

    @Override
    public Space tryGetSpace(SpaceIdentifier spaceIdentifier) throws UserFailureException {
        return this.encapsulatedService.tryGetSpace(spaceIdentifier);
    }

    @Override
    public DataSetTypeWithVocabularyTerms getDataSetType(String dataSetTypeCode) {
        return this.etlService.getDataSetType(this.systemSessionToken, dataSetTypeCode);
    }

    @Override
    public List<Sample> searchForSamples(SearchCriteria searchCriteria) {
        List<Sample> samples = this.etlService.searchForSamples(this.systemSessionToken, searchCriteria);
        return AuthorizationHelper.filterToVisible(this.encapsulatedService, this.userName, samples, sampleIdMapper, AuthorizationHelper.EntityKind.SAMPLE);
    }

    @Override
    @ManagedAuthentication
    public Sample tryGetSampleWithExperiment(SampleIdentifier sampleIdentifier) throws UserFailureException {
        Sample sample = this.encapsulatedService.tryGetSampleWithExperiment(sampleIdentifier);
        return AuthorizationHelper.filterToVisible(this.encapsulatedService, this.userName, sample, sampleIdMapper, AuthorizationHelper.EntityKind.SAMPLE);
    }

    @Override
    public List<AbstractExternalData> searchForDataSets(SearchCriteria searchCriteria) {
        List<AbstractExternalData> datasets = this.etlService.searchForDataSets(this.systemSessionToken, searchCriteria);
        return AuthorizationHelper.filterToVisible(this.encapsulatedService, this.userName, datasets, externalDataCodeMapper, AuthorizationHelper.EntityKind.DATA_SET);
    }

    @Override
    public List<Experiment> listExperiments(ProjectIdentifier projectIdentifier) {
        List<Experiment> experiments = this.etlService.listExperiments(this.systemSessionToken, projectIdentifier);
        return AuthorizationHelper.filterToVisible(this.encapsulatedService, this.userName, experiments, experimentIdMapper, AuthorizationHelper.EntityKind.EXPERIMENT);
    }

    @Override
    @ManagedAuthentication
    public Experiment tryGetExperiment(ExperimentIdentifier experimentIdentifier) throws UserFailureException {
        Experiment experiment = this.encapsulatedService.tryGetExperiment(experimentIdentifier);
        return AuthorizationHelper.filterToVisible(this.encapsulatedService, this.userName, experiment, experimentIdMapper, AuthorizationHelper.EntityKind.EXPERIMENT);
    }

    @Override
    public Collection<VocabularyTerm> listVocabularyTerms(String vocabularyCode) throws UserFailureException {
        return this.etlService.listVocabularyTerms(this.systemSessionToken, vocabularyCode);
    }

    @Override
    public Vocabulary tryGetVocabulary(String code) {
        return this.etlService.tryGetVocabulary(this.systemSessionToken, code);
    }

    @Override
    public List<Material> listMaterials(ListMaterialCriteria criteria, boolean withProperties) {
        return this.etlService.listMaterials(this.systemSessionToken, criteria, withProperties);
    }

    @Override
    @ManagedAuthentication
    public Material tryGetMaterial(MaterialIdentifier materialIdentifier) {
        return this.encapsulatedService.tryGetMaterial(materialIdentifier);
    }

    @Override
    public List<? extends EntityTypePropertyType<?>> listPropertyDefinitionsForEntityType(String code, EntityKind entityKind) {
        return this.encapsulatedService.listPropertyDefinitionsForEntityType(code, entityKind);
    }

    @Override
    public List<Metaproject> listMetaprojects() {
        return this.etlService.listMetaprojects(this.systemSessionToken, this.userName);
    }

    @Override
    public Metaproject tryGetMetaproject(String name) {
        return this.etlService.tryGetMetaproject(this.systemSessionToken, name, this.userName);
    }

    @Override
    public MetaprojectAssignments getMetaprojectAssignments(String name) {
        return this.etlService.getMetaprojectAssignments(this.systemSessionToken, name, this.userName, EnumSet.allOf(MetaprojectAssignmentsFetchOption.class));
    }

    @Override
    public List<Metaproject> listMetaprojectsForEntity(IObjectId entityId) {
        return this.etlService.listMetaprojectsForEntity(this.systemSessionToken, this.userName, entityId);
    }

    @Override
    public AbstractExternalData tryGetDataSet(String dataSetCode) throws UserFailureException {
        AbstractExternalData data = this.encapsulatedService.tryGetDataSet(dataSetCode);
        return AuthorizationHelper.filterToVisible(this.encapsulatedService, this.userName, data, externalDataCodeMapper, AuthorizationHelper.EntityKind.DATA_SET);
    }

    @Override
    public AbstractExternalData tryGetLocalDataSet(String dataSetCode) throws UserFailureException {
        AbstractExternalData data = this.encapsulatedService.tryGetLocalDataSet(dataSetCode);
        return AuthorizationHelper.filterToVisible(this.encapsulatedService, this.userName, data, externalDataCodeMapper, AuthorizationHelper.EntityKind.DATA_SET);
    }
}

