/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.servlet.HttpServletRequestUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marathon.util.spring.StreamSupportingHttpInvokerServiceExporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionWorkspaceFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String ID_PARAM = "id";
    private static final String START_BYTE_PARAM = "startByte";
    private static final String END_BYTE_PARAM = "endByte";
    private static final String FILE_NAME_PARAM = "filename";
    private static final String SIZE_PARAM = "size";
    private static final String STATUS_PARAM = "status";
    private IDssServiceRpcGeneric service;

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        StreamSupportingHttpInvokerServiceExporter serviceExporter = ServiceProvider.getDssServiceRpcGeneric();
        this.service = (IDssServiceRpcGeneric)serviceExporter.getService();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SessionWorkspaceFileUploadRequest uploadRequest = new SessionWorkspaceFileUploadRequest(request);
        uploadRequest.validate();
        long bytes = this.service.putFileSliceToSessionWorkspace(uploadRequest.getSessionId(), uploadRequest.getFileName(), uploadRequest.getStartByte().intValue(), uploadRequest.getFile());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(ID_PARAM, uploadRequest.getId());
        resultMap.put(START_BYTE_PARAM, uploadRequest.getStartByte());
        resultMap.put(END_BYTE_PARAM, uploadRequest.getEndByte());
        resultMap.put(FILE_NAME_PARAM, uploadRequest.getFileName());
        resultMap.put(SIZE_PARAM, bytes);
        resultMap.put(STATUS_PARAM, "ok");
        SessionWorkspaceFileUploadResponse uploadResponse = new SessionWorkspaceFileUploadResponse(response);
        uploadResponse.writeJson(resultMap);
    }

    private class SessionWorkspaceFileUploadRequest {
        private HttpServletRequest request;

        public SessionWorkspaceFileUploadRequest(HttpServletRequest request) {
            this.request = request;
        }

        public String getSessionId() {
            return HttpServletRequestUtils.getStringParameter(this.request, "sessionID");
        }

        public Integer getId() {
            return HttpServletRequestUtils.getIntegerParameter(this.request, SessionWorkspaceFileUploadServlet.ID_PARAM);
        }

        public Integer getStartByte() {
            return HttpServletRequestUtils.getIntegerParameter(this.request, SessionWorkspaceFileUploadServlet.START_BYTE_PARAM);
        }

        public Integer getEndByte() {
            return HttpServletRequestUtils.getIntegerParameter(this.request, SessionWorkspaceFileUploadServlet.END_BYTE_PARAM);
        }

        public String getFileName() {
            return HttpServletRequestUtils.getStringParameter(this.request, SessionWorkspaceFileUploadServlet.FILE_NAME_PARAM);
        }

        public InputStream getFile() throws IOException {
            return this.request.getInputStream();
        }

        public void validate() {
            if (this.getSessionId() == null) {
                throw new IllegalArgumentException("sessionID parameter cannot be null");
            }
            if (this.getId() == null) {
                throw new IllegalArgumentException("id parameter cannot be null");
            }
            if (this.getStartByte() == null) {
                throw new IllegalArgumentException("startByte parameter cannot be null");
            }
            if (this.getEndByte() == null) {
                throw new IllegalArgumentException("endByte parameter cannot be null");
            }
            if (this.getFileName() == null) {
                throw new IllegalArgumentException("filename parameter cannot be null");
            }
        }
    }

    private class SessionWorkspaceFileUploadResponse {
        private HttpServletResponse response;

        public SessionWorkspaceFileUploadResponse(HttpServletResponse response) {
            this.response = response;
        }

        public void writeJson(Object object) throws IOException {
            this.response.setContentType("text/json");
            this.response.setStatus(200);
            String json = new ObjectMapper().writeValueAsString(object);
            if (json != null) {
                this.response.getWriter().write(json);
            }
        }
    }
}

