/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataGraphCollectionConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataGraphConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDataMergingReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GeneratedImageTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FileBasedImageAnalysisGraphReportingPlugin
extends AbstractDataMergingReportingPlugin {
    private static final long serialVersionUID = 1L;
    private final String graphServletPath;
    private final TabularDataGraphCollectionConfiguration configuration;
    private final String SERVLET_PATH_PROP = "servlet-path";
    private static final String PROPERTIES_FILE_KEY = "properties-file";

    public FileBasedImageAnalysisGraphReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot, ';');
        this.graphServletPath = properties.getProperty("servlet-path", "datastore_server_graph/");
        String propertiesFilePath = properties.getProperty(PROPERTIES_FILE_KEY);
        if (propertiesFilePath == null) {
            throw new EnvironmentFailureException("FileBasedImageAnalysisGraphReportingPlugin requires a properties file (specified with the properties-filekey).");
        }
        this.configuration = TabularDataGraphCollectionConfiguration.getConfiguration(propertiesFilePath);
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        this.addHeaders(builder);
        if (datasets.isEmpty()) {
            return builder.getTableModel();
        }
        for (DatasetDescription dataset : datasets) {
            File dir;
            List<File> matchingFiles = this.findMatchingFiles(dataset, dir = this.getDataSubDir(context.getDirectoryProvider(), dataset));
            if (matchingFiles.size() != 1) {
                throw UserFailureException.fromTemplate("Expected exactly one matching file in the dataset %s but found %d", dataset.getDataSetCode(), matchingFiles.size());
            }
            builder.addRow(this.createRow(dataset, matchingFiles.get(0)));
        }
        return builder.getTableModel();
    }

    private void addHeaders(SimpleTableModelBuilder builder) {
        builder.addHeader("Data Set Code");
        builder.addHeader("Sample Code");
        int width = this.getThumbnailWidth();
        for (String graphTypeCode : this.getGraphTypeCodes()) {
            TabularDataGraphConfiguration graphConfig = this.configuration.getGraphConfiguration(graphTypeCode);
            builder.addHeader(graphConfig.getTitle(), width);
        }
    }

    private List<ISerializableComparable> createRow(DatasetDescription dataset, File file) {
        ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
        row.add(SimpleTableModelBuilder.asText(dataset.getDataSetCode()));
        row.add(SimpleTableModelBuilder.asText(dataset.getSampleCode()));
        for (String graphTypeCode : this.getGraphTypeCodes()) {
            GeneratedImageTableCell imageCell = new GeneratedImageTableCell(this.graphServletPath, this.getImageWidth(), this.getImageHeight(), this.getThumbnailWidth(), this.getThumbnailHeight());
            imageCell.addParameter("dataset", dataset.getDataSetCode());
            imageCell.addParameter("file", file.getAbsolutePath());
            imageCell.addParameter("type", graphTypeCode);
            row.add(imageCell);
        }
        return row;
    }

    private List<String> getGraphTypeCodes() {
        return this.configuration.getGraphNames();
    }

    private int getImageWidth() {
        return this.configuration.getImageWidth();
    }

    private int getImageHeight() {
        return this.configuration.getImageHeight();
    }

    private int getThumbnailWidth() {
        return this.configuration.getThumbnailWidth();
    }

    private int getThumbnailHeight() {
        return this.configuration.getThumbnailHeight();
    }
}

