/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HDF5ContainerBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IFileContentProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetPathInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class PathInfoProviderBasedHierarchicalContent
implements IHierarchicalContent {
    private final File root;
    private final IDelegatedAction onCloseAction;
    private IHierarchicalContentNode rootNode;
    private final ISingleDataSetPathInfoProvider dataSetPathInfoProvider;

    PathInfoProviderBasedHierarchicalContent(ISingleDataSetPathInfoProvider dataSetPathInfoProvider, File dataSetDir, IDelegatedAction onCloseAction) {
        assert (dataSetPathInfoProvider != null);
        this.dataSetPathInfoProvider = dataSetPathInfoProvider;
        this.onCloseAction = onCloseAction;
        this.root = dataSetDir;
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        if (this.rootNode == null) {
            DataSetPathInfo pathInfo = this.dataSetPathInfoProvider.getRootPathInfo();
            this.rootNode = this.asNode(pathInfo);
        }
        return this.rootNode;
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) {
        IHierarchicalContentNode nodeOrNull = this.tryGetNode(relativePath);
        if (nodeOrNull == null) {
            throw new IllegalArgumentException("Resource '" + relativePath + "' does not exist.");
        }
        return nodeOrNull;
    }

    @Override
    public IHierarchicalContentNode tryGetNode(String relativePath) {
        if (StringUtils.isBlank(relativePath)) {
            return this.getRootNode();
        }
        DataSetPathInfo pathInfoOrNull = this.dataSetPathInfoProvider.tryGetPathInfoByRelativePath(relativePath);
        if (pathInfoOrNull == null) {
            return null;
        }
        return this.asNode(pathInfoOrNull);
    }

    private IHierarchicalContentNode asNode(DataSetPathInfo pathInfo) {
        return new PathInfoNode(pathInfo);
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        List<DataSetPathInfo> matchingPathInfos = this.dataSetPathInfoProvider.listMatchingPathInfos(relativePathPattern);
        for (DataSetPathInfo pathInfo : matchingPathInfos) {
            result.add(this.asNode(pathInfo));
        }
        return result;
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        List<DataSetPathInfo> matchingPathInfos = this.dataSetPathInfoProvider.listMatchingPathInfos(startingPath, fileNamePattern);
        for (DataSetPathInfo pathInfo : matchingPathInfos) {
            result.add(this.asNode(pathInfo));
        }
        return result;
    }

    @Override
    public void close() {
        this.onCloseAction.execute();
    }

    public String toString() {
        return "PathInfoProviderBasedHierarchicalContent [root=" + this.root + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathInfoProviderBasedHierarchicalContent)) {
            return false;
        }
        PathInfoProviderBasedHierarchicalContent other = (PathInfoProviderBasedHierarchicalContent)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    private IFileContentProvider getFileContentProvider(File file) {
        if (file.exists()) {
            return PathInfoProviderBasedHierarchicalContent.asFileContentProvider(file);
        }
        File existingFile = file;
        while (existingFile != null && !existingFile.exists()) {
            existingFile = existingFile.getParentFile();
        }
        if (existingFile != null && FileUtilities.isHDF5ContainerFile(existingFile)) {
            String relativePath = FileUtilities.getRelativeFilePath(existingFile, file);
            return new HDF5ContainerBasedHierarchicalContentNode.HDF5DataSetBasedContent(existingFile, relativePath);
        }
        throw new IllegalArgumentException("Resource '" + FileUtilities.getRelativeFilePath(this.root, file) + "' is currently unavailable. It might be archived.");
    }

    private static IFileContentProvider asFileContentProvider(final File existingFile) {
        assert (existingFile.exists());
        return new IFileContentProvider(){

            @Override
            public IRandomAccessFile getReadOnlyRandomAccessFile() {
                return new RandomAccessFileImpl(existingFile, "r");
            }

            @Override
            public InputStream getInputStream() {
                try {
                    return new FileInputStream(existingFile);
                }
                catch (FileNotFoundException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        };
    }

    class PathInfoNode
    extends AbstractHierarchicalContentNode {
        private final DataSetPathInfo pathInfo;
        private IFileContentProvider fileContentProviderOrNull;

        PathInfoNode(DataSetPathInfo pathInfo) {
            this.pathInfo = pathInfo;
        }

        @Override
        public String getName() {
            return this.pathInfo.getFileName();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        protected boolean isPhysicalFile() {
            File file = this.doGetFile();
            return file.isFile();
        }

        @Override
        public boolean isDirectory() {
            return this.pathInfo.isDirectory();
        }

        @Override
        public long getLastModified() {
            return this.pathInfo.getLastModified().getTime();
        }

        @Override
        protected String doGetRelativePath() {
            return this.pathInfo.getRelativePath();
        }

        @Override
        protected List<IHierarchicalContentNode> doGetChildNodes() {
            List<DataSetPathInfo> pathInfos = PathInfoProviderBasedHierarchicalContent.this.dataSetPathInfoProvider.listChildrenPathInfos(this.pathInfo);
            ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
            for (DataSetPathInfo child : pathInfos) {
                result.add(PathInfoProviderBasedHierarchicalContent.this.asNode(child));
            }
            return result;
        }

        @Override
        protected long doGetFileLength() {
            return this.pathInfo.getSizeInBytes();
        }

        @Override
        protected int doGetChecksumCRC32() {
            Integer checksumCRC32 = this.pathInfo.getChecksumCRC32();
            if (checksumCRC32 != null) {
                return checksumCRC32;
            }
            return IOUtilities.getChecksumCRC32(this.getInputStream());
        }

        @Override
        public boolean isChecksumCRC32Precalculated() {
            return this.pathInfo.getChecksumCRC32() != null;
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            File result = this.doGetFile();
            if (result.exists()) {
                return result;
            }
            throw new UnsupportedOperationException("This is not a normal file/directory node.");
        }

        @Override
        public File tryGetFile() {
            File result = this.doGetFile();
            if (result.exists()) {
                return result;
            }
            return null;
        }

        @Override
        protected IRandomAccessFile doGetFileContent() {
            return this.getContentProvider().getReadOnlyRandomAccessFile();
        }

        @Override
        protected InputStream doGetInputStream() {
            return this.getContentProvider().getInputStream();
        }

        private IFileContentProvider getContentProvider() {
            if (this.fileContentProviderOrNull == null) {
                File file = this.doGetFile();
                this.fileContentProviderOrNull = PathInfoProviderBasedHierarchicalContent.this.getFileContentProvider(file);
            }
            return this.fileContentProviderOrNull;
        }

        private File doGetFile() {
            if (StringUtils.isBlank(this.getRelativePath())) {
                return PathInfoProviderBasedHierarchicalContent.this.root;
            }
            return new File(PathInfoProviderBasedHierarchicalContent.this.root, this.getRelativePath());
        }
    }
}

