/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserverWithCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.SetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import java.util.HashSet;
import java.util.Set;

public class CompositeDatabaseModificationObserverWithMainObserver
extends CompositeDatabaseModificationObserver {
    private final IDatabaseModificationObserverWithCallback mainObserver;

    public CompositeDatabaseModificationObserverWithMainObserver(IDatabaseModificationObserverWithCallback mainObserver) {
        assert (mainObserver != null) : "main observer cannot be null";
        this.mainObserver = mainObserver;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        HashSet relevantModifications = new HashSet();
        SetUtils.addAll(relevantModifications, this.mainObserver.getRelevantModifications());
        SetUtils.addAll(relevantModifications, super.getRelevantModifications());
        return relevantModifications.toArray(DatabaseModificationKind.EMPTY_ARRAY);
    }

    @Override
    public void update(final Set<DatabaseModificationKind> observedModifications) {
        if (SetUtils.containsAny(observedModifications, this.mainObserver.getRelevantModifications())) {
            this.mainObserver.setSuccessfulUpdateCallback(new IDelegatedAction(){

                @Override
                public void execute() {
                    CompositeDatabaseModificationObserverWithMainObserver.this.updateOtherObservers(observedModifications);
                }
            });
            this.mainObserver.update(observedModifications);
        } else {
            this.updateOtherObservers(observedModifications);
        }
    }

    private void updateOtherObservers(Set<DatabaseModificationKind> observedModifications) {
        super.update(observedModifications);
    }
}

