/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetComputeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import java.util.List;

public class DataSetProcessingMenu
extends TextToolItem {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedDataSetsGetter;

    public DataSetProcessingMenu(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedDataSetsGetter, List<DatastoreServiceDescription> processingServices) {
        super(viewContext.getMessage("menu_processing", new Object[0]));
        this.viewContext = viewContext;
        this.selectedDataSetsGetter = selectedDataSetsGetter;
        Menu submenu = new Menu();
        for (DatastoreServiceDescription service : processingServices) {
            this.addMenuItem(submenu, service);
        }
        this.setMenu(submenu);
    }

    private final void addMenuItem(Menu submenu, final DatastoreServiceDescription service) {
        IDelegatedAction menuItemAction = DataSetComputeUtils.createComputeAction(this.viewContext, this.selectedDataSetsGetter, service, null);
        IActionMenuItem menuItemKind = new IActionMenuItem(){

            @Override
            public String getMenuText(IMessageProvider messageProvider) {
                return service.getLabel();
            }

            @Override
            public String getMenuId() {
                return service.getKey();
            }
        };
        submenu.add((Component)new ActionMenu(menuItemKind, this.viewContext, menuItemAction));
    }
}

