/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.widget.form.TriggerField;

public class CodeField
extends TriggerField<String> {
    private static final int CODE_MAX_LENGTH = 60;
    private static final String CODE_CHAR_PATTERN = "a-zA-Z0-9_\\-\\.";
    public static final String CODE_CHARS = "[a-zA-Z0-9_\\-\\.]+";
    public static final String CODE_PATTERN = "^[a-zA-Z0-9_\\-\\.]+$";
    private static final String CODE_PATTERN_ALLOWED_CHARACTERS = "letters, numbers, \"-\", \"_\", \".\"";
    public static final String CODE_PATTERN_WITH_COLON = "^[a-zA-Z0-9_\\-\\.:]+$";
    private static final String CODE_PATTERN_WITH_COLON_ALLOWED_CHARACTERS = "letters, numbers, \"-\", \"_\", \".\", \":\"";
    public static final String CODE_OR_EMAIL_PATTERN = "^[a-zA-Z0-9_\\-\\.@]+$";
    private static final String CODE_OR_EMAIL_PATTERN_ALLOWED_CHARACTERS = "letters, numbers, \"-\", \"_\", \".\"@";

    public CodeField(IMessageProvider messageProvider, String label) {
        this(messageProvider, label, CodeFieldKind.BASIC_CODE);
    }

    public CodeField(IMessageProvider messageProvider, String label, CodeFieldKind kind) {
        this(messageProvider, label, kind.getPattern(), kind.getAllowedCharacters());
    }

    private CodeField(IMessageProvider messageProvider, String label, String pattern, String allowedCharacters) {
        VarcharField.configureField(this, label, true);
        this.setMaxLength(60);
        this.setRegex(pattern);
        this.getMessages().setRegexText(messageProvider.getMessage("invalid_code_message", allowedCharacters));
        this.setHideTrigger(true);
    }

    public static enum CodeFieldKind {
        BASIC_CODE("^[a-zA-Z0-9_\\-\\.]+$", "letters, numbers, \"-\", \"_\", \".\""),
        CODE_OR_EMAIL("^[a-zA-Z0-9_\\-\\.@]+$", "letters, numbers, \"-\", \"_\", \".\"@"),
        CODE_WITH_COLON("^[a-zA-Z0-9_\\-\\.:]+$", "letters, numbers, \"-\", \"_\", \".\", \":\"");

        private final String pattern;
        private final String allowedCharacters;

        private CodeFieldKind(String pattern, String allowedCharacters) {
            this.pattern = pattern;
            this.allowedCharacters = allowedCharacters;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getAllowedCharacters() {
            return this.allowedCharacters;
        }
    }
}

