/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.SetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import com.extjs.gxt.ui.client.widget.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DisposableComposite
implements IDisposableComponent {
    private Component component;
    private List<IDisposableComponentProvider> subcomponentProviders = new ArrayList<IDisposableComponentProvider>();

    public DisposableComposite(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        this.component = component;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public void addSubcomponent(final IDisposableComponent subcomponent) {
        if (subcomponent != null) {
            this.subcomponentProviders.add(new IDisposableComponentProvider(){

                @Override
                public IDisposableComponent getDisposableComponent() {
                    return subcomponent;
                }
            });
        }
    }

    public void addSubcomponent(IDisposableComponentProvider subcomponentProvider) {
        if (subcomponentProvider != null) {
            this.subcomponentProviders.add(subcomponentProvider);
        }
    }

    public void clearSubcomponents() {
        this.subcomponentProviders.clear();
    }

    @Override
    public void dispose() {
        for (IDisposableComponentProvider subcomponentProvider : this.subcomponentProviders) {
            IDisposableComponent subcomponent = subcomponentProvider.getDisposableComponent();
            if (subcomponent == null) continue;
            subcomponent.dispose();
        }
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        HashSet relevantModifications = new HashSet();
        for (IDisposableComponentProvider subcomponentProvider : this.subcomponentProviders) {
            DatabaseModificationKind[] subcomponentRelevantModifications;
            IDisposableComponent subcomponent = subcomponentProvider.getDisposableComponent();
            if (subcomponent == null || (subcomponentRelevantModifications = subcomponent.getRelevantModifications()) == null) continue;
            SetUtils.addAll(relevantModifications, subcomponentRelevantModifications);
        }
        return relevantModifications.toArray(DatabaseModificationKind.EMPTY_ARRAY);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        for (IDisposableComponentProvider subcomponentProvider : this.subcomponentProviders) {
            DatabaseModificationKind[] subcomponentRelevantModifications;
            IDisposableComponent subcomponent = subcomponentProvider.getDisposableComponent();
            if (subcomponent == null || (subcomponentRelevantModifications = subcomponent.getRelevantModifications()) == null || !SetUtils.containsAny(observedModifications, subcomponentRelevantModifications)) continue;
            subcomponent.update(observedModifications);
        }
    }
}

