/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.AttachmentsFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

abstract class AbstractProjectEditRegisterForm
extends AbstractRegistrationForm {
    protected final IViewContext<ICommonClientServiceAsync> viewContext;
    protected CodeField projectCodeField;
    protected MultilineVarcharField projectDescriptionField;
    protected SpaceSelectionWidget spaceField;
    private AttachmentsFileFieldManager attachmentsManager;
    protected final String sessionKey;

    protected abstract void saveProject();

    protected abstract void setValues();

    protected AbstractProjectEditRegisterForm(IViewContext<ICommonClientServiceAsync> viewContext) {
        this(viewContext, null);
    }

    protected AbstractProjectEditRegisterForm(IViewContext<ICommonClientServiceAsync> viewContext, TechId projectIdOrNull) {
        super(viewContext, AbstractProjectEditRegisterForm.createId(projectIdOrNull), 120, 500);
        this.viewContext = viewContext;
        this.sessionKey = AbstractProjectEditRegisterForm.createId(projectIdOrNull);
        this.attachmentsManager = new AttachmentsFileFieldManager(this.sessionKey, viewContext);
        this.projectCodeField = this.createProjectCodeField();
        this.spaceField = this.createGroupField();
        this.projectDescriptionField = this.createProjectDescriptionField();
        this.addUploadFeatures(this.sessionKey);
    }

    public static String createId(TechId id) {
        String editOrRegister = id == null ? "register" : "edit_" + id;
        return "openbis_project-" + editOrRegister + "_form";
    }

    SpaceSelectionWidget getGroupField() {
        return this.spaceField;
    }

    private final CodeField createProjectCodeField() {
        CodeField codeField = new CodeField(this.viewContext, this.viewContext.getMessage("code", new Object[0]));
        codeField.setId(String.valueOf(this.getId()) + "_code");
        return codeField;
    }

    private final MultilineVarcharField createProjectDescriptionField() {
        return new DescriptionField(this.viewContext, false, this.getId());
    }

    private final SpaceSelectionWidget createGroupField() {
        SpaceSelectionWidget field = new SpaceSelectionWidget(this.viewContext, this.getId(), false, false);
        FieldUtil.markAsMandatory(field);
        field.setFieldLabel(this.viewContext.getMessage("group", new Object[0]));
        return field;
    }

    @Override
    protected void resetPanel() {
        super.resetPanel();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
    }

    @Override
    protected void revertPanel() {
        super.revertPanel();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
    }

    private final void addFormFields() {
        this.formPanel.add((Widget)this.projectCodeField);
        this.formPanel.add((Widget)this.spaceField);
        this.formPanel.add((Widget)this.projectDescriptionField);
        this.attachmentsManager.addAttachmentFieldSetsToPanel(this.formPanel);
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                AbstractProjectEditRegisterForm.this.saveProject();
            }

            @Override
            protected void setUploadEnabled() {
                AbstractProjectEditRegisterForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
    }

    void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractProjectEditRegisterForm.this.formPanel.isValid()) {
                    if (AbstractProjectEditRegisterForm.this.attachmentsManager.filesDefined() > 0) {
                        AbstractProjectEditRegisterForm.this.setUploadEnabled(false);
                        AbstractProjectEditRegisterForm.this.formPanel.submit();
                    } else {
                        AbstractProjectEditRegisterForm.this.saveProject();
                    }
                }
            }
        });
    }

    @Override
    protected final void submitValidForm() {
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.setLoading(true);
        this.loadForm();
    }

    protected abstract void loadForm();

    protected void initGUI() {
        this.setValues();
        this.addFormFields();
        this.setLoading(false);
        this.layout();
    }

    protected List<NewAttachment> extractAttachments() {
        return this.attachmentsManager.extractAttachments();
    }
}

