/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SpaceModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.AbstractProjectEditRegisterForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ProjectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ProjectEditForm
extends AbstractProjectEditRegisterForm {
    private Project originalProject;
    private final TechId projectId;

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext, TechId projectId) {
        ProjectEditForm form = new ProjectEditForm(viewContext, projectId);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)form.getGroupField());
    }

    protected ProjectEditForm(IViewContext<ICommonClientServiceAsync> viewContext, TechId projectId) {
        super(viewContext, projectId);
        this.setRevertButtonVisible(true);
        this.projectId = projectId;
    }

    @Override
    protected void saveProject() {
        ProjectUpdates updates = new ProjectUpdates();
        updates.setAttachments(this.extractAttachments());
        updates.setAttachmentSessionKey(this.sessionKey);
        updates.setDescription((String)this.projectDescriptionField.getValue());
        updates.setTechId(this.projectId);
        updates.setVersion(this.originalProject.getVersion());
        Space space = (Space)this.spaceField.tryGetSelected();
        updates.setSpaceCode(space == null ? null : space.getCode());
        this.viewContext.getCommonService().updateProject(updates, new ProjectEditCallback(this.viewContext));
    }

    @Override
    protected void setValues() {
        FieldUtil.setValueWithUnescaping((Field<String>)this.projectDescriptionField, this.originalProject.getDescription());
        this.projectCodeField.setValue(this.originalProject.getCode());
        this.projectCodeField.setEnabled(false);
        this.spaceField.selectSpaceAndUpdateOriginal(this.originalProject.getSpace().getCode());
    }

    public void updateOriginalValues() {
        this.projectDescriptionField.setOriginalValue((String)this.projectDescriptionField.getValue());
        this.projectCodeField.setOriginalValue((String)this.projectCodeField.getValue());
        this.spaceField.setOriginalValue((Object)((SpaceModel)((Object)this.spaceField.getValue())));
    }

    void setOriginalProject(Project project) {
        this.originalProject = project;
    }

    @Override
    protected void loadForm() {
        ((ICommonClientServiceAsync)this.viewContext.getService()).getProjectInfo(this.projectId, (AsyncCallback<Project>)new ProjectInfoCallback(this.viewContext));
    }

    private final class ProjectEditCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Integer> {
        ProjectEditCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Integer result) {
            ProjectEditForm.this.originalProject.setVersion(result);
            ProjectEditForm.this.updateOriginalValues();
            super.process(result);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(Integer result) {
            return "Project <b>" + ProjectEditForm.this.originalProject.getCode() + "</b> successfully updated.";
        }
    }

    private final class ProjectInfoCallback
    extends AbstractAsyncCallback<Project> {
        private ProjectInfoCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Project result) {
            ProjectEditForm.this.setOriginalProject(result);
            ProjectEditForm.this.initGUI();
        }
    }
}

