/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.event.WindowListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.ui.Widget;

public class SimpleDialog
extends Dialog {
    public static final String ACCEPT_BUTTON_ID = "openbis_dialog-accept-button";
    private final IMessageProvider messageProvider;
    private final Button acceptButton;
    private IDelegatedAction acceptActionOrNull;
    private IDelegatedAction cancelActionOrNull;

    public SimpleDialog(Widget widget, String heading, String acceptButtonLabel, IMessageProvider messageProvider, Button ... buttons) {
        this.messageProvider = messageProvider;
        this.setHeading(heading);
        this.setButtons("");
        this.setScrollMode(Style.Scroll.AUTO);
        this.setHideOnButtonClick(true);
        this.setModal(true);
        this.setLayout((Layout)new FitLayout());
        this.add(widget);
        Button[] buttonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            super.addButton(button);
            ++n2;
        }
        this.acceptButton = this.createAcceptButton(acceptButtonLabel);
        this.addButton(this.acceptButton);
        this.addButton(this.createCancelButton());
        this.addWindowListener(new WindowListener(){

            public void windowHide(WindowEvent we) {
                SimpleDialog.this.fireCancel();
            }
        });
    }

    public void setEnableOfAcceptButton(boolean enable) {
        this.acceptButton.setEnabled(enable);
    }

    private Button createCancelButton() {
        Button button = new Button(this.messageProvider.getMessage("button_cancel", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                SimpleDialog.this.fireCancel();
            }
        });
        return button;
    }

    private Button createAcceptButton(String label) {
        Button button = new Button(label, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                SimpleDialog.this.fireAccept();
            }
        });
        button.setId(ACCEPT_BUTTON_ID);
        return button;
    }

    public void setAcceptAction(IDelegatedAction acceptActionOrNull) {
        this.acceptActionOrNull = acceptActionOrNull;
    }

    public void setCancelAction(IDelegatedAction cancelActionOrNull) {
        this.cancelActionOrNull = cancelActionOrNull;
    }

    private void fireAccept() {
        if (this.acceptActionOrNull != null) {
            this.acceptActionOrNull.execute();
        }
    }

    private void fireCancel() {
        if (this.cancelActionOrNull != null) {
            this.cancelActionOrNull.execute();
        } else {
            this.hide();
        }
    }

    public void addButton(Button button) {
        if (this.isHideOnButtonClick()) {
            button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    SimpleDialog.this.hide();
                }
            });
        }
        super.addButton(button);
    }
}

